/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.powersource.Output;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BatteryChargeStatusRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(BatteryChargeStatusRule.class);
    private static final String kBatteryDischargedMsg = "BatteryDischargedFlexEvent";
    private static final String kBatteryChargeInRangeMsg = "BatteryChargeInRangeFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEvent;

    public BatteryChargeStatusRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = Battery.BatteryChargeInRange.getObjectId();
    }

    @Override
    public synchronized void execute() {
        try {
            GetResult getResult = this.theDataSource.get(com.apcc.m11.ds.powersource.Battery.BatteryChargeStatus.getObjectId());
            GetResult getResult2 = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult.getValue();
            Object object2 = getResult2.getValue();
            if (object instanceof Integer && object2 instanceof Integer) {
                int n = (Integer)object;
                int n2 = (Integer)object2;
                ObjectId objectId = null;
                String string = null;
                boolean bl = false;
                String string2 = null;
                if (n == 2) {
                    if (n2 == 1) {
                        logger.debug("BATTERY DISCHARGED - low_batery = true online");
                        objectId = Battery.BatteryDischarged.getObjectId();
                        string = kBatteryDischargedMsg;
                        string2 = Battery.BatteryDischarged.getEventId();
                    }
                } else if (n == 1 && n2 == 1) {
                    logger.debug("BATTERY CHARGE IN RANGE - low_batery = false online");
                    objectId = Battery.BatteryChargeInRange.getObjectId();
                    string = kBatteryChargeInRangeMsg;
                    bl = true;
                    string2 = Battery.BatteryChargeInRange.getEventId();
                }
                if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                    this.theLastEvent = objectId;
                }
            }
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
        }
    }
}

