/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.net.InetAddress;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommunicationStatusRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(CommunicationStatusRule.class);
    private static final String kCommLostMsg = "CommunicationLostFlexEvent";
    private static final String kCommLostWhileOnBattMsg = "CommunicationLostWhileOnBattFlexEvent";
    private static final String kCommEstablishedMsg = "CommunicationEstablishedFlexEvent";
    private static final String kNetCommLostMsg = "NetworkCommunicationLostFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEvent;
    private int theOutputState = 0;
    private int theLastOutputState = 0;
    private String theLastCommLostMsg;
    private PowerSourceComponent thePowerSourceComponent;
    private ServiceManager services;

    public CommunicationStatusRule(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, FlexEventGenerator flexEventGenerator, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        logger.debug("CommunicationStatusRule Constructor");
        this.thePowerSourceComponent = powerSourceComponent;
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = null;
    }

    @Override
    public synchronized void execute() {
        block31: {
            ObjectId objectId = null;
            String string = null;
            boolean bl = false;
            String string2 = null;
            try {
                GetResult getResult = this.theDataSource.get(Communication.CommunicationStatus.getObjectId());
                Object object = getResult.getValue();
                if (object instanceof Integer) {
                    Object object2;
                    Integer n = (Integer)object;
                    GetResult getResult2 = this.theDataSource.get(Output.OutputState.getObjectId());
                    if (!getResult2.hasError()) {
                        this.theLastOutputState = this.theOutputState;
                        try {
                            object2 = (Integer)getResult2.getValue();
                            this.theOutputState = (Integer)object2;
                        }
                        catch (Exception exception) {
                            logger.error((Object)exception);
                            this.theOutputState = 0;
                        }
                    }
                    if (n == 2) {
                        if (this.theLastOutputState == 2 || this.theOutputState == 2) {
                            objectId = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLostOnBattery.getObjectId();
                            string = kCommLostWhileOnBattMsg;
                            bl = false;
                            string2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLostOnBattery.getEventId();
                            if (this.theLastEvent == null || objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                                String string3;
                                object2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getObjectId();
                                this.theLastCommLostMsg = string3 = kCommLostMsg;
                                this.theFlexEventGenerator.postEvent(new DetailedEvent((ObjectId)object2, true, new EventMessageFormatter(string3), false, com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getEventId()));
                            }
                        } else {
                            objectId = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getObjectId();
                            string = kCommLostMsg;
                            bl = false;
                            string2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getEventId();
                        }
                    } else if (n == 1) {
                        objectId = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationEstablished.getObjectId();
                        string = kCommEstablishedMsg;
                        bl = true;
                        string2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationEstablished.getEventId();
                        try {
                            if (this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV() && !this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() && (object2 = (getResult2 = this.theDataSource.get(Output.OutputState.getObjectId())).getValue()) instanceof Integer) {
                                int n2 = (Integer)object2;
                            }
                        }
                        catch (InvalidObjectIdException invalidObjectIdException) {
                            logger.error("InvalidObjectIdException", (Throwable)invalidObjectIdException);
                        }
                        if (this.theLastEvent != null && this.theLastEvent.equals((Object)com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLostOnBattery.getObjectId())) {
                            this.theFlexEventGenerator.postEvent(new Event(com.apcc.m11.ds.events.flexevents.powersource.Communication.NetCommunicationLost.getObjectId(), false));
                        }
                    }
                    if (this.theLastEvent == null || objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                        logger.debug("Firing new_event:" + String.valueOf(objectId) + " lastEvent:" + String.valueOf(this.theLastEvent));
                        if (this.theLastEvent != null) {
                            this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                        }
                        this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                        logger.debug("Firing DONE new_event:" + String.valueOf(objectId) + " lastEvent:" + String.valueOf(this.theLastEvent));
                        this.theLastEvent = objectId;
                    }
                    break block31;
                }
                objectId = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getObjectId();
                string = kCommLostMsg;
                bl = false;
                string2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getEventId();
                if (this.theLastEvent == null || objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                    logger.debug("Firing new_event:" + objectId.toString() + " lastEvent:" + String.valueOf(this.theLastEvent));
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                    this.theLastEvent = objectId;
                }
            }
            catch (CommunicationException communicationException) {
                logger.debug("execute", (Throwable)communicationException);
                if (this.theLastOutputState == 2 || this.theOutputState == 2) {
                    objectId = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLostOnBattery.getObjectId();
                    string = kCommLostWhileOnBattMsg;
                    bl = false;
                    string2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLostOnBattery.getEventId();
                    if (this.theLastEvent == null || objectId != null && !this.theLastEvent.equals((Object)objectId) || objectId != null && this.theLastEvent.equals((Object)objectId) && !this.theLastCommLostMsg.equals(kNetCommLostMsg)) {
                        var6_9 = com.apcc.m11.ds.events.flexevents.powersource.Communication.NetCommunicationLost.getObjectId();
                        String string4 = kNetCommLostMsg;
                        String string5 = com.apcc.m11.ds.events.flexevents.powersource.Communication.NetCommunicationLost.getEventId();
                        this.theLastCommLostMsg = string4;
                        this.theFlexEventGenerator.postEvent(new DetailedEvent((ObjectId)var6_9, true, new EventMessageFormatter(string4), bl, string5));
                    }
                } else {
                    try {
                        var6_9 = this.theDataSource.get(TCPIPCommunication.IpAddress.getObjectId());
                        Object object = var6_9.getValue();
                        if (object instanceof InetAddress) {
                            objectId = com.apcc.m11.ds.events.flexevents.powersource.Communication.NetCommunicationLost.getObjectId();
                            string = kNetCommLostMsg;
                            bl = false;
                            string2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.NetCommunicationLost.getEventId();
                        }
                    }
                    catch (InvalidObjectIdException invalidObjectIdException) {
                        logger.error("execute", (Throwable)invalidObjectIdException);
                    }
                    catch (CommunicationException communicationException2) {
                        logger.error("execute", (Throwable)communicationException2);
                    }
                }
                if (objectId != null && !objectId.equals((Object)this.theLastEvent)) {
                    boolean bl2;
                    logger.debug("Firing new_event:" + String.valueOf(objectId) + " lastEvent:" + String.valueOf(this.theLastEvent));
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                    this.theLastEvent = objectId;
                    if ((this.theLastEvent.equals((Object)com.apcc.m11.ds.events.flexevents.powersource.Communication.NetCommunicationLost.getObjectId()) || this.theLastEvent.equals((Object)com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLostOnBattery.getObjectId())) && (bl2 = this.services.getConfigurationManager().getBoolean("NetworkManagementCard", "enrolWithNMC", true).booleanValue())) {
                        if (this.thePowerSourceComponent.getOutletGroup() != null) {
                            this.thePowerSourceComponent.communicationRegisterWithSOG(this.thePowerSourceComponent.getOutletGroup());
                        } else {
                            this.thePowerSourceComponent.communicationRegister();
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.debug((Object)exception);
                objectId = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getObjectId();
                string = kCommLostMsg;
                bl = false;
                string2 = com.apcc.m11.ds.events.flexevents.powersource.Communication.CommunicationLost.getEventId();
                if (objectId.equals((Object)this.theLastEvent)) break block31;
                this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), false, string2));
                this.theLastEvent = objectId;
            }
        }
    }
}

