/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.environment.Contacts;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import com.apcc.m11.ds.powersource.Output;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContactFaultsRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(ContactFaultsRule.class);
    private static final String kContactFault1FlexEvent = "ContactFault1FlexEvent";
    private static final String kContactFault2FlexEvent = "ContactFault2FlexEvent";
    private static final String kContactFault3FlexEvent = "ContactFault3FlexEvent";
    private static final String kContactFault4FlexEvent = "ContactFault4FlexEvent";
    private static final String kContactNormal1FlexEvent = "ContactNormal1FlexEvent";
    private static final String kContactNormal2FlexEvent = "ContactNormal2FlexEvent";
    private static final String kContactNormal3FlexEvent = "ContactNormal3FlexEvent";
    private static final String kContactNormal4FlexEvent = "ContactNormal4FlexEvent";
    private IDataSource theDataSource;
    private FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEventContact1;
    private ObjectId theLastEventContact2;
    private ObjectId theLastEventContact3;
    private ObjectId theLastEventContact4;

    public ContactFaultsRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEventContact1 = EnvironmentalEvents.ContactNormal1.getObjectId();
        this.theLastEventContact2 = EnvironmentalEvents.ContactNormal2.getObjectId();
        this.theLastEventContact3 = EnvironmentalEvents.ContactNormal3.getObjectId();
        this.theLastEventContact4 = EnvironmentalEvents.ContactNormal4.getObjectId();
    }

    private boolean isContactFaultPresent(ObjectId objectId) throws CommunicationException, InvalidObjectIdException {
        boolean bl;
        boolean bl2 = false;
        GetResult getResult = this.theDataSource.get(objectId);
        Object object = getResult.getValue();
        if (object instanceof Boolean && (bl = ((Boolean)object).booleanValue())) {
            bl2 = true;
        }
        return bl2;
    }

    private void generateEvent(ObjectId objectId, ObjectId objectId2, String string, boolean bl, String string2) {
        this.theFlexEventGenerator.postEvent(new Event(objectId, false));
        this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId2, true, new EventMessageFormatter(string), bl, string2));
    }

    @Override
    public void execute() {
        ObjectId objectId = null;
        String string = null;
        boolean bl = false;
        try {
            GetResult getResult = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult.getValue();
            int n = (Integer)object;
            if (n == 5) {
                this.theLastEventContact1 = EnvironmentalEvents.ContactNormal1.getObjectId();
                this.theLastEventContact2 = EnvironmentalEvents.ContactNormal2.getObjectId();
                this.theLastEventContact3 = EnvironmentalEvents.ContactNormal3.getObjectId();
                this.theLastEventContact4 = EnvironmentalEvents.ContactNormal4.getObjectId();
            }
            if (this.isContactFaultPresent(Contacts.ContactFault1.getObjectId()) && n != 5) {
                objectId = EnvironmentalEvents.ContactFault1.getObjectId();
                string = EnvironmentalEvents.ContactFault1.getEventId();
                bl = false;
                if (!this.theLastEventContact1.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact1, objectId, kContactFault1FlexEvent, bl, string);
                    this.theLastEventContact1 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.ContactNormal1.getObjectId();
                string = EnvironmentalEvents.ContactNormal1.getEventId();
                bl = true;
                if (!this.theLastEventContact1.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact1, objectId, kContactNormal1FlexEvent, bl, string);
                    this.theLastEventContact1 = objectId;
                }
            }
            if (this.isContactFaultPresent(Contacts.ContactFault2.getObjectId()) && n != 5) {
                objectId = EnvironmentalEvents.ContactFault2.getObjectId();
                string = EnvironmentalEvents.ContactFault2.getEventId();
                bl = false;
                if (!this.theLastEventContact2.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact2, objectId, kContactFault2FlexEvent, bl, string);
                    this.theLastEventContact2 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.ContactNormal2.getObjectId();
                string = EnvironmentalEvents.ContactNormal2.getEventId();
                bl = true;
                if (!this.theLastEventContact2.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact2, objectId, kContactNormal2FlexEvent, bl, string);
                    this.theLastEventContact2 = objectId;
                }
            }
            if (this.isContactFaultPresent(Contacts.ContactFault3.getObjectId()) && n != 5) {
                objectId = EnvironmentalEvents.ContactFault3.getObjectId();
                string = EnvironmentalEvents.ContactFault3.getEventId();
                bl = false;
                if (!this.theLastEventContact3.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact3, objectId, kContactFault3FlexEvent, bl, string);
                    this.theLastEventContact3 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.ContactNormal3.getObjectId();
                string = EnvironmentalEvents.ContactNormal3.getEventId();
                bl = true;
                if (!this.theLastEventContact3.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact3, objectId, kContactNormal3FlexEvent, bl, string);
                    this.theLastEventContact3 = objectId;
                }
            }
            if (this.isContactFaultPresent(Contacts.ContactFault4.getObjectId()) && n != 5) {
                objectId = EnvironmentalEvents.ContactFault4.getObjectId();
                string = EnvironmentalEvents.ContactFault4.getEventId();
                bl = false;
                if (!this.theLastEventContact4.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact4, objectId, kContactFault4FlexEvent, bl, string);
                    this.theLastEventContact4 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.ContactNormal4.getObjectId();
                string = EnvironmentalEvents.ContactNormal4.getEventId();
                bl = true;
                if (!this.theLastEventContact4.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventContact4, objectId, kContactNormal4FlexEvent, bl, string);
                    this.theLastEventContact4 = objectId;
                }
            }
        }
        catch (CommunicationException communicationException) {
            logger.warn("Object not currently available", (Throwable)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error("Invalid ObjectId", (Throwable)invalidObjectIdException);
        }
    }
}

