/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.environment.Humidity;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HumidityProbeStateRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(HumidityProbeStateRule.class);
    private static final String kHumidityInRangeProbe1FlexEvent = "HumidityInRangeProbe1FlexEvent";
    private static final String kHumidityOutOfRangeProbe1FlexEvent = "HumidityOutOfRangeProbe1FlexEvent";
    private static final String kHumidityInRangeProbe2FlexEvent = "HumidityInRangeProbe2FlexEvent";
    private static final String kHumidityOutOfRangeProbe2FlexEvent = "HumidityOutOfRangeProbe2FlexEvent";
    private IDataSource theDataSource;
    private FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEventProbe1;
    private ObjectId theLastEventProbe2;

    public HumidityProbeStateRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEventProbe1 = EnvironmentalEvents.HumidityInRangeProbe1.getObjectId();
        this.theLastEventProbe2 = EnvironmentalEvents.HumidityInRangeProbe2.getObjectId();
    }

    private boolean isHumidityProbeOutOfRange(ObjectId objectId, ObjectId objectId2) throws CommunicationException, InvalidObjectIdException {
        boolean bl;
        boolean bl2 = false;
        GetResult getResult = this.theDataSource.get(objectId);
        Object object = getResult.getValue();
        if (object instanceof Boolean && (bl = ((Boolean)object).booleanValue())) {
            bl2 = true;
        }
        if (!bl2 && (object = (getResult = this.theDataSource.get(objectId2)).getValue()) instanceof Boolean && (bl = ((Boolean)object).booleanValue())) {
            bl2 = true;
        }
        return bl2;
    }

    private void generateEvent(ObjectId objectId, ObjectId objectId2, String string, boolean bl, String string2) {
        this.theFlexEventGenerator.postEvent(new Event(objectId, false));
        this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId2, true, new EventMessageFormatter(string), bl, string2));
    }

    @Override
    public void execute() {
        ObjectId objectId = null;
        String string = null;
        boolean bl = false;
        ObjectId objectId2 = Humidity.HiHumidityViolationProbe1.getObjectId();
        ObjectId objectId3 = Humidity.LowHumidityViolationProbe1.getObjectId();
        ObjectId objectId4 = Humidity.HiHumidityViolationProbe2.getObjectId();
        ObjectId objectId5 = Humidity.LowHumidityViolationProbe2.getObjectId();
        try {
            GetResult getResult = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult.getValue();
            int n = (Integer)object;
            if (n == 5) {
                this.theLastEventProbe1 = EnvironmentalEvents.HumidityInRangeProbe1.getObjectId();
                this.theLastEventProbe2 = EnvironmentalEvents.HumidityInRangeProbe2.getObjectId();
            }
            if (this.isHumidityProbeOutOfRange(objectId2, objectId3) && n != 5) {
                objectId = EnvironmentalEvents.HumidityOutOfRangeProbe1.getObjectId();
                string = EnvironmentalEvents.HumidityOutOfRangeProbe1.getEventId();
                bl = false;
                if (!this.theLastEventProbe1.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe1, objectId, kHumidityOutOfRangeProbe1FlexEvent, bl, string);
                    this.theLastEventProbe1 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.HumidityInRangeProbe1.getObjectId();
                string = EnvironmentalEvents.HumidityInRangeProbe1.getEventId();
                bl = true;
                if (!this.theLastEventProbe1.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe1, objectId, kHumidityInRangeProbe1FlexEvent, bl, string);
                    this.theLastEventProbe1 = objectId;
                }
            }
            if (this.isHumidityProbeOutOfRange(objectId4, objectId5) && n != 5) {
                objectId = EnvironmentalEvents.HumidityOutOfRangeProbe2.getObjectId();
                string = EnvironmentalEvents.HumidityOutOfRangeProbe2.getEventId();
                bl = false;
                if (!this.theLastEventProbe2.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe2, objectId, kHumidityOutOfRangeProbe2FlexEvent, bl, string);
                    this.theLastEventProbe2 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.HumidityInRangeProbe2.getObjectId();
                string = EnvironmentalEvents.HumidityInRangeProbe2.getEventId();
                bl = true;
                if (!this.theLastEventProbe2.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe2, objectId, kHumidityInRangeProbe2FlexEvent, bl, string);
                    this.theLastEventProbe2 = objectId;
                }
            }
        }
        catch (Exception exception) {
            String string2 = "";
            try {
                GetResult getResult = this.theDataSource.get(TCPIPCommunication.IpAddress.getObjectId());
                string2 = ((InetAddress)getResult.getValue()).getHostAddress();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            logger.debug(String.valueOf(exception) + " ipaddress of the NMC is :" + string2);
        }
    }
}

