/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Temperature;
import com.apcc.m11.ds.powersource.OperatingStatus;

public class InternalTempRule
implements IEventRule {
    private static final String kInternalTempExceededMsg = "InternalTempExceededFlexEvent";
    private static final String kInternalTempInRangeMsg = "InternalTempInRangeFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    ObjectId theLastEvent;

    public InternalTempRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = Temperature.MaxInternalTempInRange.getObjectId();
    }

    @Override
    public void execute() {
        try {
            GetResult getResult = this.theDataSource.get(OperatingStatus.InternalTemperatureWarningIndicator.getObjectId());
            Object object = getResult.getValue();
            if (object instanceof Integer) {
                int n = (Integer)object;
                ObjectId objectId = null;
                String string = null;
                String string2 = null;
                boolean bl = false;
                if (n == 2) {
                    objectId = Temperature.MaxInternalTempExceeded.getObjectId();
                    string = kInternalTempExceededMsg;
                    string2 = Temperature.MaxInternalTempExceeded.getEventId();
                    bl = false;
                } else if (n == 1) {
                    objectId = Temperature.MaxInternalTempInRange.getObjectId();
                    string = kInternalTempInRangeMsg;
                    string2 = Temperature.MaxInternalTempInRange.getEventId();
                    bl = true;
                }
                if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                    this.theLastEvent = objectId;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

