/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.LoadCapability;
import com.apcc.m11.ds.powersource.FaultTolerance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadCapabilityRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(LoadCapabilityRule.class);
    private static final String kMinLoadCapabilityLostMsg = "MinLoadCapabilityLostFlexEvent";
    private static final String kMinLoadCapabilityRegainedMsg = "MinLoadCapabilityRegainedFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEvent;

    public LoadCapabilityRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = LoadCapability.MinLoadCapabilityRegained.getObjectId();
    }

    @Override
    public void execute() {
        try {
            GetResult getResult = this.theDataSource.get(FaultTolerance.LoadCapabilityStatus.getObjectId());
            Object object = getResult.getValue();
            if (object instanceof Integer) {
                String string;
                int n = (Integer)object;
                ObjectId objectId = null;
                String string2 = null;
                boolean bl = false;
                if (n == 2) {
                    objectId = LoadCapability.MinLoadCapabilityLost.getObjectId();
                    string2 = kMinLoadCapabilityLostMsg;
                    string = LoadCapability.MinLoadCapabilityLost.getEventId();
                } else {
                    objectId = LoadCapability.MinLoadCapabilityRegained.getObjectId();
                    string2 = kMinLoadCapabilityRegainedMsg;
                    string = LoadCapability.MinLoadCapabilityRegained.getEventId();
                    bl = true;
                }
                if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string2), bl, string));
                    this.theLastEvent = objectId;
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

