/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Battery;
import com.apcc.m11.ds.powersource.Output;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LowBatteryStatusRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(LowBatteryStatusRule.class);
    private static final String kLowBatteryMsg = "LowBatteryFlexEvent";
    private static final String kReturnFromLowBatteryMsg = "ReturnFromLowBatteryFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEvent;

    public LowBatteryStatusRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = Battery.ReturnFromLowBattery.getObjectId();
    }

    @Override
    public synchronized void execute() {
        try {
            GetResult getResult = this.theDataSource.get(com.apcc.m11.ds.powersource.Battery.BatteryChargeStatus.getObjectId());
            GetResult getResult2 = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult.getValue();
            Object object2 = getResult2.getValue();
            if (object instanceof Integer && object2 instanceof Integer) {
                int n = (Integer)object;
                int n2 = (Integer)object2;
                ObjectId objectId = null;
                String string = null;
                String string2 = null;
                boolean bl = false;
                if (n == 2) {
                    if (n2 == 2) {
                        logger.debug("LOW BATTERY - low_batery = true on battery");
                        objectId = Battery.LowBattery.getObjectId();
                        string = kLowBatteryMsg;
                        string2 = Battery.LowBattery.getEventId();
                        bl = false;
                    } else if (n2 == 1) {
                        logger.debug("LOW BATTERY SOLVED - low_batery = true online");
                        objectId = Battery.ReturnFromLowBattery.getObjectId();
                        string = kReturnFromLowBatteryMsg;
                        string2 = Battery.ReturnFromLowBattery.getEventId();
                        bl = true;
                    }
                } else if (n == 1) {
                    logger.debug("LOW BATTERY SOLVED - low_batery = false");
                    objectId = Battery.ReturnFromLowBattery.getObjectId();
                    string = kReturnFromLowBatteryMsg;
                    string2 = Battery.ReturnFromLowBattery.getEventId();
                    bl = true;
                }
                if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                    this.theLastEvent = objectId;
                }
            }
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
        }
    }
}

