/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.MonitoringStartedMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Communication;
import com.apcc.pcns.configservice.ProductVersion;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MonitoringStartedRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(MonitoringStartedRule.class);
    private static final String MONITORING_STARTED_MSG = "MonitoringStartedFlexEvent";
    private FlexEventGenerator eventHandler = null;
    private ProductVersion productVersion;
    private boolean eventSent = false;

    public MonitoringStartedRule(@NonNull FlexEventGenerator flexEventGenerator, @NonNull ProductVersion productVersion) {
        if (flexEventGenerator == null) {
            throw new IllegalArgumentException("anEventGenerator is marked non-null but is null");
        }
        if (productVersion == null) {
            throw new IllegalArgumentException("productVersion is marked non-null but is null");
        }
        logger.debug("MonitoringStartedRule: constructor");
        this.productVersion = productVersion;
        this.eventHandler = flexEventGenerator;
    }

    @Override
    public synchronized void execute() {
        logger.debug("MonitoringStartedRule: execute()");
        String string = this.productVersion.getVersion();
        if (!this.eventSent && StringUtils.isNotEmpty((CharSequence)string)) {
            logger.debug("Monitoring Started Event");
            this.eventHandler.postEvent(new DetailedEvent(Communication.MonitoringStarted.getObjectId(), true, new MonitoringStartedMessageFormatter(MONITORING_STARTED_MSG, string), true, Communication.MonitoringStarted.getEventId()));
            this.eventSent = true;
        }
    }
}

