/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletStatusRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(OutletStatusRule.class);
    private static final String kSOGPowerOffMsg = "PowerOffSOGFlexEvent";
    private static final String kSOGPowerOnMsg = "PowerOnSOGFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastOutletEvent;
    private PowerSourceComponent thePowerSourceComponent;

    public OutletStatusRule(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastOutletEvent = UtilityLineStatus.OutletOn.getObjectId();
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public synchronized void execute() {
        try {
            Integer n;
            GetResult getResult = this.theDataSource.get(OperatingStatus.IsUPSOutletAware.getObjectId());
            Boolean bl = (Boolean)getResult.getValue();
            if (bl.booleanValue()) {
                logger.trace("non-outlet aware UPS");
                return;
            }
            GetResult getResult2 = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult2.getValue();
            if (object instanceof Integer) {
                n = (Integer)object;
                switch (n) {
                    case 5: 
                    case 8: {
                        return;
                    }
                }
            }
            n = null;
            String string = null;
            boolean bl2 = false;
            boolean bl3 = Boolean.TRUE;
            Integer n2 = this.thePowerSourceComponent.getOutletState();
            if (n2 != null) {
                boolean bl4 = bl3 = !Integer.valueOf(0).equals(n2);
            }
            if (bl3) {
                n = UtilityLineStatus.OutletOn.getObjectId();
                string = kSOGPowerOnMsg;
                bl2 = true;
            } else {
                n = UtilityLineStatus.OutletOff.getObjectId();
                string = kSOGPowerOffMsg;
            }
            if (n != null && !this.theLastOutletEvent.equals((Object)n)) {
                this.theFlexEventGenerator.postEvent(new Event(this.theLastOutletEvent, false));
                this.theFlexEventGenerator.postEvent(new DetailedEvent((ObjectId)n, true, new EventMessageFormatter(string), bl2));
                this.theLastOutletEvent = n;
            }
        }
        catch (CommunicationException communicationException) {
            logger.debug((Object)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error((Object)invalidObjectIdException);
        }
    }
}

