/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.OutletOffMessageFormatter;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutletTurnOffInitiatedRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(OutletTurnOffInitiatedRule.class);
    private static final String kSOGTurnOffInitiatedMsg = "SOGTurnOffInitiatedFlexEvent";
    protected IDataSource theDataSource;
    private PowerSourceComponent thePowerSourceComponent;
    protected FlexEventGenerator theFlexEventGenerator;
    private boolean theTurnOffInitiatedFlag = false;

    public OutletTurnOffInitiatedRule(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public void execute() {
        try {
            Object object;
            logger.trace("execute() - start");
            GetResult getResult = this.theDataSource.get(OperatingStatus.IsUPSOutletAware.getObjectId());
            Boolean bl = (Boolean)getResult.getValue();
            if (bl.booleanValue()) {
                logger.trace("Non_outlet aware UPS");
                return;
            }
            GetResult getResult2 = this.theDataSource.get(OperatingStatus.OutletState.getObjectId());
            int n = 0;
            if (!getResult2.hasError()) {
                object = getResult2.getValue();
                n = (Integer)object;
            }
            if (n == 3) {
                if (!this.theTurnOffInitiatedFlag) {
                    String string;
                    Object object2;
                    object = this.theDataSource.get(TCPIPCommunication.OutletGroup.getObjectId());
                    Object object3 = object.getValue();
                    if (object3 instanceof OutletGroup) {
                        object2 = (OutletGroup)object3;
                        string = object2.getName();
                    } else {
                        string = "UNKNOWN";
                    }
                    object2 = new DetailedEvent(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId(), true, new OutletOffMessageFormatter(kSOGTurnOffInitiatedMsg, string), false, ShutdownEvents.UPSOutletTurnOffInitiated.getEventId());
                    logger.info("Outlet Turn off set");
                    this.theFlexEventGenerator.postEvent((Event)object2);
                    this.theTurnOffInitiatedFlag = true;
                }
            } else {
                boolean bl2 = Boolean.TRUE;
                Integer n2 = this.thePowerSourceComponent.getOutletState();
                if (n2 != null) {
                    boolean bl3 = bl2 = !Integer.valueOf(0).equals(n);
                }
                if (bl2 && this.theTurnOffInitiatedFlag) {
                    Event event = new Event(ShutdownEvents.UPSOutletTurnOffInitiated.getObjectId(), false);
                    logger.info("Outlet turnoff cleared");
                    this.theFlexEventGenerator.postEvent(event);
                    this.theTurnOffInitiatedFlag = false;
                }
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug("invalidObjectID requested:" + invalidObjectIdException.getReason());
        }
        catch (CommunicationException communicationException) {
            logger.trace(" coms not established ");
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        logger.trace("execute() - end");
    }
}

