/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.Output;
import java.lang.constant.Constable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OverloadStatusRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(OverloadStatusRule.class);
    private static final String kOverloadMsg = "OverloadFlexEvent";
    private static final String kOverloadSolvedMsg = "OverloadSolvedFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEvent;

    public OverloadStatusRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = UtilityLineStatus.OverloadSolved.getObjectId();
    }

    @Override
    public void execute() {
        try {
            Constable constable;
            GetResult getResult = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult.getValue();
            if (object instanceof Integer && (Integer)(constable = (Integer)object) == 8) {
                return;
            }
            getResult = this.theDataSource.get(Output.OverloadState.getObjectId());
            object = getResult.getValue();
            if (object instanceof Boolean) {
                constable = (Boolean)object;
                ObjectId objectId = null;
                String string = null;
                String string2 = null;
                boolean bl = false;
                if (((Boolean)constable).booleanValue()) {
                    objectId = UtilityLineStatus.Overload.getObjectId();
                    string = kOverloadMsg;
                    string2 = UtilityLineStatus.Overload.getEventId();
                    bl = false;
                } else {
                    objectId = UtilityLineStatus.OverloadSolved.getObjectId();
                    string = kOverloadSolvedMsg;
                    string2 = UtilityLineStatus.OverloadSolved.getEventId();
                    bl = true;
                }
                if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                    this.theLastEvent = objectId;
                }
            }
        }
        catch (CommunicationException communicationException) {
            logger.trace(" coms not established ");
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

