/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import com.apcc.m11.ds.powersource.FaultTolerance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParallelRedundancyRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(ParallelRedundancyRule.class);
    private static final String kParallelRedundancyLostMsg = "ParallelRedundancyLostFlexEvent";
    private static final String kParallelRedundancyRegainedMsg = "ParallelRedundancyRegainedFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    ObjectId theLastEvent;

    public ParallelRedundancyRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = Redundancy.ParallelRedundancyRegained.getObjectId();
    }

    @Override
    public void execute() {
        try {
            GetResult getResult = this.theDataSource.get(FaultTolerance.ParallelRedundancyStatus.getObjectId());
            Object object = getResult.getValue();
            int n = 0;
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            ObjectId objectId = null;
            String string = null;
            String string2 = null;
            boolean bl = false;
            if (n == 2) {
                objectId = Redundancy.ParallelRedundancyLost.getObjectId();
                string = kParallelRedundancyLostMsg;
                string2 = Redundancy.ParallelRedundancyLost.getEventId();
                bl = false;
            } else {
                objectId = Redundancy.ParallelRedundancyRegained.getObjectId();
                string = kParallelRedundancyRegainedMsg;
                string2 = Redundancy.ParallelRedundancyRegained.getEventId();
                bl = true;
            }
            if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                this.theLastEvent = objectId;
                logger.info(string + ":" + n);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

