/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PowerSourceTurnOffInitiatedRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(PowerSourceTurnOffInitiatedRule.class);
    private static final String kTurnOffInitiatedMsg = "PowerSourceTurnOffInitiatedFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private boolean thePSTurnOffInitiatedFlag;
    private PowerSourceComponent thePowerSourceComponent;

    public PowerSourceTurnOffInitiatedRule(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.thePSTurnOffInitiatedFlag = false;
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public void execute() {
        try {
            logger.trace("execute()");
            GetResult getResult = this.theDataSource.get(OperatingStatus.IsUPSOutletAware.getObjectId());
            Boolean bl = false;
            if (getResult != null) {
                bl = (Boolean)getResult.getValue();
            }
            if (!bl.booleanValue() && this.thePowerSourceComponent.getOutletGroup() != null) {
                logger.trace("Enrolled on outlet of an outlet aware UPS");
                return;
            }
            GetResult getResult2 = this.theDataSource.get(OperatingStatus.PowerSourceTurnOffPending.getObjectId());
            Object object = getResult2.getValue();
            int n = -1;
            int n2 = -1;
            if (!(object instanceof Boolean)) {
                logger.info("Received unexpected result of type:" + String.valueOf(object.getClass()));
            } else {
                Boolean bl2 = (Boolean)object;
                logger.trace("Shutdown pending: " + bl2);
                if (!this.thePSTurnOffInitiatedFlag) {
                    logger.trace("thePSTurnOffInitiatedFlag FALSE Message Not already Sent");
                    if (bl2.booleanValue()) {
                        logger.info("PowerSource Turn Off Initiated true");
                        Event event = new Event(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId(), true, (IFormatter)new EventMessageFormatter(kTurnOffInitiatedMsg));
                        logger.info("Posting: PowerSourceTurnOffInitiated");
                        this.theFlexEventGenerator.postEvent(event);
                        this.thePSTurnOffInitiatedFlag = true;
                    }
                } else {
                    logger.trace("thePSTurnOffInitiatedFlag TRUE message already sent");
                    if (!bl2.booleanValue()) {
                        Object object2;
                        GetResult getResult3 = this.theDataSource.get(Output.OutputState.getObjectId());
                        if (!getResult3.hasError()) {
                            object2 = getResult3.getValue();
                            n = (Integer)object2;
                        }
                        if (n != 5) {
                            logger.info("PowerSource Turn Off Initiated cleared");
                            logger.info("clear PowerSourceTurn Off");
                            object2 = new Event(ShutdownEvents.PowerSourceTurnOffInitiated.getObjectId(), false);
                            this.theFlexEventGenerator.postEvent((Event)object2);
                            this.thePSTurnOffInitiatedFlag = false;
                        }
                    } else {
                        logger.trace("Shutdown Still Pending");
                    }
                }
            }
        }
        catch (CommunicationException communicationException) {
            logger.trace(" coms not established ");
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

