/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.powersource.Redundancy;
import com.apcc.m11.ds.powersource.FaultTolerance;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RedundancyRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(RedundancyRule.class);
    private static final String kMinRedundancyLostMsg = "MinRedundancyLostFlexEvent";
    private static final String kMinRedundancyRegainedMsg = "MinRedundancyRegainedFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    ObjectId theLastEvent;

    public RedundancyRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEvent = Redundancy.MinRedundancyRegained.getObjectId();
    }

    @Override
    public void execute() {
        try {
            GetResult getResult = this.theDataSource.get(FaultTolerance.RedundancyStatus.getObjectId());
            Object object = getResult.getValue();
            int n = 0;
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            GetResult getResult2 = this.theDataSource.get(FaultTolerance.RequiredRedundancy.getObjectId());
            GetResult getResult3 = this.theDataSource.get(FaultTolerance.CurrentRedundancy.getObjectId());
            Object object2 = null;
            Object object3 = null;
            if (!getResult2.hasError() && !getResult3.hasError()) {
                object2 = getResult2.getValue();
                object3 = getResult3.getValue();
            }
            int n2 = -1;
            int n3 = -1;
            if (object2 instanceof Integer && object3 instanceof Integer) {
                n2 = (Integer)object2;
                n3 = (Integer)object3;
            }
            ObjectId objectId = null;
            String string = null;
            String string2 = null;
            boolean bl = false;
            if (n3 < n2 || n == 2) {
                objectId = Redundancy.MinRedundancyLost.getObjectId();
                string = kMinRedundancyLostMsg;
                string2 = Redundancy.MinRedundancyLost.getEventId();
                bl = false;
            } else {
                objectId = Redundancy.MinRedundancyRegained.getObjectId();
                string = kMinRedundancyRegainedMsg;
                string2 = Redundancy.MinRedundancyRegained.getEventId();
                bl = true;
            }
            if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                this.theLastEvent = objectId;
                logger.info(string + " :" + n3 + ":" + n2 + ":" + n);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }
}

