/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.ds.events.internalevents.powersource.OperationalEvents;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.OperatingStatus;
import com.apcc.m11.ds.powersource.Output;

public class SilconHotStandbyRule
implements IEventRule {
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private int kNotHotStandby = 0;
    private int kHotStandby = 1;
    private int kNoSupport = 2;
    private int theLastState = this.kNotHotStandby;

    public SilconHotStandbyRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
    }

    @Override
    public void execute() {
        try {
            GetResult getResult = this.theDataSource.get(OperatingStatus.ParallelUnitsCount.getObjectId());
            Integer n = (Integer)getResult.getValue();
            if (n < 2) {
                this.sendParallelSilconNotSupported();
            } else {
                GetResult getResult2;
                Object object;
                if (this.theLastState == this.kNoSupport) {
                    this.clearParallelSilconNotSupported();
                }
                if ((object = (getResult2 = this.theDataSource.get(Output.SilconOutputStatus.getObjectId())).getValue()) instanceof Integer) {
                    if ((Integer)object == 6 || (Integer)object == 7) {
                        if (this.theLastState != this.kHotStandby) {
                            this.theLastState = this.kHotStandby;
                            this.theFlexEventGenerator.postEvent(new Event(OperationalEvents.SilconSwitchedIntoStandby.getObjectId()));
                        }
                    } else if (this.theLastState != this.kNotHotStandby) {
                        this.theLastState = this.kNotHotStandby;
                        this.theFlexEventGenerator.postEvent(new Event(OperationalEvents.SilconSwitchedOffStandby.getObjectId()));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.sendParallelSilconNotSupported();
        }
    }

    private void clearParallelSilconNotSupported() {
        if (this.theLastState == this.kNoSupport) {
            try {
                Integer n;
                GetResult getResult = this.theDataSource.get(Communication.CommunicationStatus.getObjectId());
                Object object = getResult.getValue();
                if (object instanceof Integer && (n = (Integer)object) == 1) {
                    this.theLastState = this.kNotHotStandby;
                    this.theFlexEventGenerator.postEvent(new Event(OperationalEvents.ParallelSilconSupported.getObjectId()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sendParallelSilconNotSupported() {
        if (this.theLastState != this.kNoSupport) {
            try {
                Integer n;
                GetResult getResult = this.theDataSource.get(Communication.CommunicationStatus.getObjectId());
                Object object = getResult.getValue();
                if (object instanceof Integer && (n = (Integer)object) == 1) {
                    this.theLastState = this.kNoSupport;
                    this.theFlexEventGenerator.postEvent(new Event(OperationalEvents.ParallelSilconNotSupported.getObjectId()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

