/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.environment.Temperature;
import com.apcc.m11.ds.events.flexevents.EnvironmentalEvents;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TempProbeStateRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(TempProbeStateRule.class);
    private static final String kTempInRangeProbe1FlexEvent = "TempInRangeProbe1FlexEvent";
    private static final String kTempOutOfRangeProbe1FlexEvent = "TempOutOfRangeProbe1FlexEvent";
    private static final String kTempInRangeProbe2FlexEvent = "TempInRangeProbe2FlexEvent";
    private static final String kTempOutOfRangeProbe2FlexEvent = "TempOutOfRangeProbe2FlexEvent";
    private IDataSource theDataSource;
    private FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEventProbe1;
    private ObjectId theLastEventProbe2;

    public TempProbeStateRule(IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.theLastEventProbe1 = EnvironmentalEvents.TempInRangeProbe1.getObjectId();
        this.theLastEventProbe2 = EnvironmentalEvents.TempInRangeProbe2.getObjectId();
    }

    private boolean isTemperatureProbeOutOfRange(ObjectId objectId, ObjectId objectId2) throws CommunicationException, InvalidObjectIdException {
        boolean bl;
        boolean bl2 = false;
        GetResult getResult = this.theDataSource.get(objectId);
        Object object = getResult.getValue();
        if (object instanceof Boolean && (bl = ((Boolean)object).booleanValue())) {
            bl2 = true;
        }
        if (!bl2 && (object = (getResult = this.theDataSource.get(objectId2)).getValue()) instanceof Boolean && (bl = ((Boolean)object).booleanValue())) {
            bl2 = true;
        }
        return bl2;
    }

    private void generateEvent(ObjectId objectId, ObjectId objectId2, String string, boolean bl, String string2) {
        this.theFlexEventGenerator.postEvent(new Event(objectId, false));
        this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId2, true, new EventMessageFormatter(string), bl, string2));
    }

    @Override
    public void execute() {
        ObjectId objectId = null;
        String string = null;
        boolean bl = false;
        ObjectId objectId2 = Temperature.HiTempViolationProbe1.getObjectId();
        ObjectId objectId3 = Temperature.LowTempViolationProbe1.getObjectId();
        ObjectId objectId4 = Temperature.HiTempViolationProbe2.getObjectId();
        ObjectId objectId5 = Temperature.LowTempViolationProbe2.getObjectId();
        try {
            GetResult getResult = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult.getValue();
            int n = (Integer)object;
            if (n == 5) {
                this.theLastEventProbe1 = EnvironmentalEvents.TempInRangeProbe1.getObjectId();
                this.theLastEventProbe2 = EnvironmentalEvents.TempInRangeProbe2.getObjectId();
            }
            if (this.isTemperatureProbeOutOfRange(objectId2, objectId3) && n != 5) {
                objectId = EnvironmentalEvents.TempOutOfRangeProbe1.getObjectId();
                string = EnvironmentalEvents.TempOutOfRangeProbe1.getEventId();
                bl = false;
                if (!this.theLastEventProbe1.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe1, objectId, kTempOutOfRangeProbe1FlexEvent, bl, string);
                    this.theLastEventProbe1 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.TempInRangeProbe1.getObjectId();
                string = EnvironmentalEvents.TempInRangeProbe1.getEventId();
                bl = true;
                if (!this.theLastEventProbe1.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe1, objectId, kTempInRangeProbe1FlexEvent, bl, string);
                    this.theLastEventProbe1 = objectId;
                }
            }
            if (this.isTemperatureProbeOutOfRange(objectId4, objectId5) && n != 5) {
                objectId = EnvironmentalEvents.TempOutOfRangeProbe2.getObjectId();
                string = EnvironmentalEvents.TempOutOfRangeProbe2.getEventId();
                bl = false;
                if (!this.theLastEventProbe2.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe2, objectId, kTempOutOfRangeProbe2FlexEvent, bl, string);
                    this.theLastEventProbe2 = objectId;
                }
            } else {
                objectId = EnvironmentalEvents.TempInRangeProbe2.getObjectId();
                string = EnvironmentalEvents.TempInRangeProbe2.getEventId();
                bl = true;
                if (!this.theLastEventProbe2.equals((Object)objectId)) {
                    this.generateEvent(this.theLastEventProbe2, objectId, kTempInRangeProbe2FlexEvent, bl, string);
                    this.theLastEventProbe2 = objectId;
                }
            }
        }
        catch (Exception exception) {
            String string2 = "";
            try {
                GetResult getResult = this.theDataSource.get(TCPIPCommunication.IpAddress.getObjectId());
                string2 = ((InetAddress)getResult.getValue()).getHostAddress();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            logger.debug(String.valueOf(exception) + " ipaddress of the NMC is :" + string2);
        }
    }
}

