/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.eventrules;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.DetailedEvent;
import com.apcc.m11.components.stdpowersource.FlexEventGenerator;
import com.apcc.m11.components.stdpowersource.IEventRule;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.m11.components.stdpowersource.formatters.EventMessageFormatter;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.events.flexevents.powersource.UtilityLineStatus;
import com.apcc.m11.ds.powersource.Output;
import com.apcc.pcns.util.CountdownTimer;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UtilityLineStatusRule
implements IEventRule {
    private static final Logger logger = LogManager.getLogger(UtilityLineStatusRule.class);
    private static final String kOnlineMsg = "PowerRestoredFlexEvent";
    private static final String kOnBatteryMsg = "PowerFailedFlexEvent";
    private static final String kSelfTestMsg = "SelfTestFlexEvent";
    private static final String kPowerOffMsg = "PowerOffFlexEvent";
    protected IDataSource theDataSource;
    protected FlexEventGenerator theFlexEventGenerator;
    private ObjectId theLastEvent;
    private PowerSourceComponent thePowerSourceComponent;
    private ObjectId thePreTestEvent;

    public UtilityLineStatusRule(PowerSourceComponent powerSourceComponent, IDataSource iDataSource, FlexEventGenerator flexEventGenerator) {
        this.theDataSource = iDataSource;
        this.theFlexEventGenerator = flexEventGenerator;
        this.thePreTestEvent = this.theLastEvent = UtilityLineStatus.PowerRestored.getObjectId();
        this.thePowerSourceComponent = powerSourceComponent;
    }

    @Override
    public synchronized void execute() {
        try {
            GetResult getResult = this.theDataSource.get(Output.OutputState.getObjectId());
            Object object = getResult.getValue();
            boolean bl = false;
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                ObjectId objectId = null;
                String string = null;
                String string2 = null;
                switch (n) {
                    case 1: {
                        objectId = UtilityLineStatus.PowerRestored.getObjectId();
                        string = kOnlineMsg;
                        bl = true;
                        string2 = UtilityLineStatus.PowerRestored.getEventId();
                        break;
                    }
                    case 2: {
                        objectId = UtilityLineStatus.PowerFailed.getObjectId();
                        string = kOnBatteryMsg;
                        string2 = UtilityLineStatus.PowerFailed.getEventId();
                        break;
                    }
                    case 8: {
                        objectId = UtilityLineStatus.SelfTest.getObjectId();
                        string = kSelfTestMsg;
                        if (this.theLastEvent.equals((Object)objectId)) break;
                        this.thePreTestEvent = this.theLastEvent;
                        break;
                    }
                    case 5: {
                        if (this.thePowerSourceComponent.isInBypass()) break;
                        objectId = UtilityLineStatus.PowerOff.getObjectId();
                        string = kPowerOffMsg;
                        string2 = UtilityLineStatus.PowerOff.getEventId();
                        logger.trace("PowerOff fired");
                        break;
                    }
                    default: {
                        objectId = null;
                        string = null;
                    }
                }
                if (objectId != null && !this.theLastEvent.equals((Object)objectId)) {
                    this.theFlexEventGenerator.postEvent(new Event(this.theLastEvent, false));
                    if (objectId.equals((Object)UtilityLineStatus.PowerRestored.getObjectId())) {
                        logger.debug("delay clearing on battery");
                        new CountdownTimer(500L, TimeUnit.MILLISECONDS).await(this);
                        this.theFlexEventGenerator.postEvent(new Event(UtilityLineStatus.PowerFailed.getObjectId(), false));
                        logger.debug("delay clearing on battery");
                        new CountdownTimer(100L, TimeUnit.MILLISECONDS).await(this);
                    }
                    if (!(this.theLastEvent.equals((Object)UtilityLineStatus.SelfTest.getObjectId()) && this.thePreTestEvent.equals((Object)UtilityLineStatus.PowerRestored.getObjectId()) && objectId.equals((Object)UtilityLineStatus.PowerRestored.getObjectId()))) {
                        this.theFlexEventGenerator.postEvent(new DetailedEvent(objectId, true, new EventMessageFormatter(string), bl, string2));
                    }
                    this.theLastEvent = objectId;
                    if (objectId.equals((Object)UtilityLineStatus.PowerOff.getObjectId())) {
                        Event event = new Event(ShutdownEvents.TurnOffUpsStarting.getObjectId(), false);
                        this.theFlexEventGenerator.postEvent(event);
                    }
                }
            }
        }
        catch (CommunicationException communicationException) {
            logger.debug((Object)communicationException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.error((Object)invalidObjectIdException);
        }
    }
}

