/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.formatters;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.UnsupportedLocaleException;
import java.text.NumberFormat;
import java.util.Locale;

public class TemperatureFormatter
implements IFormatter {
    private static final long serialVersionUID = 6568152285327578387L;
    private static final String kFahrenheitSuffix = "\u00b0F";
    private static final String kCelsiusSuffix = "\u00b0C";
    private static final int kTemperatureDecimalDigits = 2;

    public String format(Object object) throws FormatterException, UnsupportedLocaleException {
        return this.format(object, Locale.getDefault());
    }

    public String format(Object object, Locale locale) throws FormatterException, UnsupportedLocaleException {
        StringBuilder stringBuilder = null;
        if (object instanceof Number) {
            float f = ((Number)object).floatValue();
            if (locale.getCountry().equals(Locale.US.getCountry())) {
                f = this.convertCelsiusToFahrenheit(f);
            }
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            stringBuilder = new StringBuilder(numberFormat.format(f));
            if (locale.getCountry().equals(Locale.US.getCountry())) {
                stringBuilder.append(kFahrenheitSuffix);
            } else {
                stringBuilder.append(kCelsiusSuffix);
            }
        } else {
            throw new FormatterException(1);
        }
        return stringBuilder.toString();
    }

    private float convertCelsiusToFahrenheit(float f) {
        return 9.0f * f / 5.0f + 32.0f;
    }
}

