/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.stdpowersource.tasks;

import com.apcc.m11.components.stdpowersource.NMCComms;
import com.apcc.m11.components.stdpowersource.PowerSourceComponent;
import com.apcc.pcns.ServiceManager;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NMCRegisterTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger(NMCRegisterTask.class);
    protected PowerSourceComponent theStdPwrSrc;
    protected NMCComms nmcComms;
    protected ServiceManager services;

    public NMCRegisterTask(PowerSourceComponent powerSourceComponent, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        logger.debug("NMCRegister thread ctor");
        this.services = serviceManager;
        this.theStdPwrSrc = powerSourceComponent;
    }

    @Override
    public void run() {
        logger.trace("started");
        this.nmcComms = new NMCComms(this.theStdPwrSrc, this.services);
        this.nmcComms.enrolWithNMC();
        this.nmcComms.checkNmcShutdownSupport();
        logger.trace("completed");
    }

    public int getRegistrationResult() {
        int n = 0;
        if (this.nmcComms != null) {
            n = this.nmcComms.getRegistrationResult();
        }
        return n;
    }
}

