/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.component.ComponentFailureException;
import com.apcc.m11.arch.component.ComponentID;
import com.apcc.m11.arch.component.IComponent;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataConsumer;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import com.apcc.m11.arch.m11component.IM11Component;
import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.webserver.RestartSNMPTask;
import com.apcc.m11.components.webserver.WebServerEventProducer;
import com.apcc.m11.components.webserver.WebServerSettings;
import com.apcc.m11.components.webserver.WebServerThread;
import com.apcc.m11.components.webserver.certificates.SelfSignedCertGenerator;
import com.apcc.m11.components.webserver.certificates.WebserverCertificateManager;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.SecurityUtils;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.arch.interfaces.DataConsumer;
import com.apcc.m11.ds.arch.interfaces.DataSource;
import com.apcc.m11.ds.arch.interfaces.EventProducer;
import com.apcc.m11.ds.arch.interfaces.M11Component;
import com.apcc.m11.ds.services.WebServerGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.snmp.PcnsBaseAgent;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.OSVersionInfo;
import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration2.event.ConfigurationEvent;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.reloading.ReloadingEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebServer
implements IComponent,
IM11Component,
IDataConsumer,
IDataSource {
    private static final Logger logger = LogManager.getLogger(WebServer.class);
    private static final String kProtocolChangePendingStorageId = "ProtocolChangePending";
    private static final String kComponentID = "WebServer";
    private static final String kComponentName = "WebServer";
    private static final String kComponentVersion = "1.0.0";
    private String subjectCommonName = "APC Software Application";
    private String issuerCommonName = "APC Software";
    private String organisation = "Schneider Electric";
    private String organisationUnit = "Schneider Electric";
    private WebServerSettings theWebServerSettings = null;
    private WebServerThread theWebServerThread = null;
    private IDataSource theDataSource = null;
    private Vector<ObjectId> theSupportedOids = null;
    private IPermanentStorage thePermanentStorage = null;
    private WebServerEventProducer theWebServerEventProducer = null;
    private ReentrantLock restartLock = new ReentrantLock();
    private String NetworkConfig = null;
    private Thread SNMPAgentThread = null;
    private PcnsBaseAgent SNMPAgent = null;
    private ServiceManager services;
    private EventListener<ConfigurationEvent> configEventListener;
    private EventListener<ReloadingEvent> configReloadListener;
    private CountdownTimer restartTimer;
    public WebserverCertificateManager theCertificateManager = null;
    public SelfSignedCertGenerator theSelfSignedCertificateGen = null;
    private AuthHelper authHelper;

    private void initKeystore() {
        logger.debug("initKeystore() - start");
        String string = this.readKeystorePasswordFromINI();
        String string2 = this.authHelper.getWebserverKeystorePassword();
        if (StringUtils.isBlank((CharSequence)string2) && StringUtils.isBlank((CharSequence)string)) {
            logger.info("initKeystore() - Creating a new keystore with a new password");
            string = this.authHelper.getRandomKey();
        }
        if (StringUtils.isNotBlank((CharSequence)string)) {
            logger.info("initKeystore() - Setting the keystore password");
            String string3 = this.theWebServerSettings.getKeystorePassword();
            if (StringUtils.isNotBlank((CharSequence)string2)) {
                string3 = string2;
            }
            string = StringUtils.trim((String)string);
            if (StringUtils.isBlank((CharSequence)string3)) {
                string3 = string;
            }
            this.theWebServerSettings.setKeystorePassword(string);
            if (!StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
                boolean bl;
                boolean bl2 = bl = StringUtils.length((CharSequence)string) >= 6;
                if (!bl) {
                    logger.error("initKeystore() - Keystore password should contain at least 6 characters.");
                }
                this.theCertificateManager.setPassPhrase(StringUtils.defaultString((String)string3, (String)string));
                if (bl && this.theCertificateManager.updateKeystore(string, this.theWebServerSettings)) {
                    logger.info("initKeystore() - Keystore password change successful");
                    this.authHelper.setWebserverKeystorePassword(string);
                    this.services.getConfigurationManager().clearProperty("NetworkManagementCard", "KeystorePassword");
                } else {
                    logger.error("initKeystore() - Keystore password change failed - using old keystore password");
                    this.theWebServerSettings.setKeystorePassword(string3);
                    this.theCertificateManager.setPassPhrase(string3);
                    this.theCertificateManager.createKeystore(this.theWebServerSettings);
                }
            } else {
                logger.info("initKeystore() - Keystore password not changed - new password is same as existing password");
                this.theCertificateManager.setPassPhrase(string);
                this.theCertificateManager.createKeystore(this.theWebServerSettings);
                this.services.getConfigurationManager().clearProperty("NetworkManagementCard", "KeystorePassword");
            }
        } else {
            logger.debug("initKeystore() - Using keystore password stored in m11.cfg");
            this.theWebServerSettings.setKeystorePassword(string2);
            this.theCertificateManager.setPassPhrase(string2);
            this.theCertificateManager.createKeystore(this.theWebServerSettings);
        }
    }

    private String readKeystorePasswordFromINI() {
        String string = null;
        if (this.services.getConfigurationManager().containsKey("NetworkManagementCard", "KeystorePassword")) {
            logger.debug("keystore password key contained in INI.");
            try {
                string = this.services.getConfigurationManager().getString("NetworkManagementCard", "KeystorePassword");
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
        }
        return string;
    }

    private void initCertificateRoutines() {
        String string = Utils.getFQDNForLocalHostAddress(null);
        logger.debug("FQDN=" + string);
        this.issuerCommonName = string;
        this.subjectCommonName = string;
    }

    public Object getInstanceOf(ObjectId objectId) throws InvalidObjectIdException {
        WebServer webServer = null;
        if (!objectId.equals((Object)M11Component.kOid)) {
            throw new InvalidObjectIdException();
        }
        webServer = this;
        return webServer;
    }

    public ComponentID getComponentID() {
        return new ComponentID("WebServer");
    }

    public String getComponentName() {
        return "WebServer";
    }

    public String getComponentVersion() {
        return kComponentVersion;
    }

    public Object getInterface(ObjectId objectId) throws InvalidObjectIdException {
        Object object = null;
        if (objectId.equals((Object)M11Component.kOid)) {
            object = this;
        } else if (objectId.equals((Object)DataConsumer.kOid)) {
            object = this;
        } else if (objectId.equals((Object)DataSource.kOid)) {
            object = this;
        } else if (objectId.equals((Object)EventProducer.kOid)) {
            object = this.theWebServerEventProducer;
        } else {
            throw new InvalidObjectIdException("Interface not supported");
        }
        return object;
    }

    public synchronized void init(IPermanentStorage iPermanentStorage) {
        logger.info("WebServer.init()");
        try {
            this.services = ServiceManager.getInstance();
            this.thePermanentStorage = iPermanentStorage;
            this.services.getAuthHelper().setPermanentStorage(iPermanentStorage);
            this.authHelper = this.services.getAuthHelper();
            System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "false");
            System.setProperty("sun.security.ssl.allowLegacyHelloMessages", "true");
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            this.theWebServerSettings = new WebServerSettings(this.services);
            this.theCertificateManager = new WebserverCertificateManager();
            this.initCertificateRoutines();
            this.theSelfSignedCertificateGen = new SelfSignedCertGenerator(this.subjectCommonName, this.issuerCommonName, this.organisation, this.organisationUnit);
            this.theCertificateManager.setSelfSignedCertGenerator(this.theSelfSignedCertificateGen);
            this.theSupportedOids = new Vector();
            this.theSupportedOids.addElement(WebServerGroup.SSLEnabled.getObjectId());
            this.theWebServerEventProducer = new WebServerEventProducer();
            this.services.getTrustStoreManager().initKeystore();
            this.initKeystore();
            X509Certificate x509Certificate = this.theCertificateManager.getServerCertificate();
            this.services.getApplicationSettings().setWebCertificateThumbPrint(SecurityUtils.getX509CertificateThumbPrint(x509Certificate));
            this.loadConfiguration();
            try {
                ComponentID componentID = new ComponentID("PacketRepeater");
                Object object = this.thePermanentStorage.readData(componentID, "InstallGroup");
                if (object != null && object instanceof Integer) {
                    M11Servlet.setInstallGroup((Integer)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setProtocolChangePending(false);
            M11Servlet.setEventProducer(this.theWebServerEventProducer);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
        logger.debug("init() - end");
    }

    private void startSNMP() {
        logger.info("startSNMP() - start");
        this.restartLock.lock();
        try {
            if (this.SNMPAgentThread != null) {
                logger.debug("stop the old one");
                this.SNMPAgent.stop();
                if (this.SNMPAgentThread.isAlive()) {
                    this.SNMPAgentThread.join();
                }
            }
            this.SNMPAgent = new PcnsBaseAgent(new File("SNMP4JTestAgentBC.cfg"), new File("SNMP4JTestAgentConfig.cfg"), this.theDataSource, this.thePermanentStorage, this.services);
            this.SNMPAgentThread = new Thread((Runnable)((Object)this.SNMPAgent));
            this.SNMPAgentThread.start();
        }
        catch (IOException iOException) {
            logger.error("Unable to start SNMPAgent");
        }
        catch (InterruptedException interruptedException) {
            logger.error(" SNMPAgent:" + interruptedException.getLocalizedMessage());
        }
        finally {
            this.restartLock.unlock();
        }
        logger.debug("startSNMP() - end");
    }

    public void restartSNMP() {
        logger.debug("restartSNMP");
        if (this.SNMPAgentThread != null) {
            this.restartLock.lock();
            try {
                logger.debug("restartSNMP() - Restarting SNMP");
                this.startSNMP();
            }
            finally {
                this.restartLock.unlock();
            }
        }
    }

    private void setProtocolChangePending(boolean bl) {
        try {
            this.thePermanentStorage.writeData(this.getComponentID(), kProtocolChangePendingStorageId, (Object)bl);
        }
        catch (StorageEntryException storageEntryException) {
            logger.error((Object)storageEntryException);
        }
    }

    public synchronized void start() throws ComponentFailureException {
        try {
            logger.info("Start");
            if (this.theWebServerThread != null) {
                this.theWebServerThread.terminate();
            }
            this.theWebServerThread = new WebServerThread(this.theWebServerSettings, this.thePermanentStorage, this.services);
            this.theWebServerThread.start();
            OSVersionInfo.getOSVersionInfo();
            this.startSNMP();
            if (this.configEventListener == null) {
                this.configEventListener = new EventListener<ConfigurationEvent>(){

                    public void onEvent(ConfigurationEvent configurationEvent) {
                        try {
                            logger.trace("Webserver update:{} {}", (Object)configurationEvent.getEventType(), (Object)configurationEvent.getPropertyName());
                            if (!configurationEvent.isBeforeUpdate()) {
                                boolean bl;
                                logger.debug("Webserver update handle:{} {}", (Object)configurationEvent.getEventType(), (Object)configurationEvent.getPropertyName());
                                String string = configurationEvent.getPropertyName();
                                if (configurationEvent.getEventType() == ConfigurationEvent.SET_PROPERTY && StringUtils.startsWith((CharSequence)string, (CharSequence)"Networking")) {
                                    WebServer.this.loadConfiguration();
                                }
                                boolean bl2 = configurationEvent.getEventType() == ConfigurationEvent.CLEAR_PROPERTY || configurationEvent.getEventType() == ConfigurationEvent.ADD_PROPERTY || configurationEvent.getEventType() == ConfigurationEvent.SET_PROPERTY;
                                boolean bl3 = bl = StringUtils.contains((CharSequence)string, (CharSequence)"IP_") || StringUtils.startsWith((CharSequence)string, (CharSequence)"SNMP") && !StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"SNMP.Logging_Level_Override");
                                if (bl2 && bl) {
                                    WebServer.this.rateLimitedRestart();
                                }
                            }
                        }
                        catch (Exception exception) {
                            logger.error("onEvent", (Throwable)exception);
                        }
                    }
                };
            }
            if (this.configReloadListener == null) {
                this.configReloadListener = new EventListener<ReloadingEvent>(){

                    public void onEvent(ReloadingEvent reloadingEvent) {
                        try {
                            logger.debug("reloadEvent {}", (Object)reloadingEvent);
                            WebServer.this.rateLimitedRestart();
                        }
                        catch (Exception exception) {
                            logger.error("onEvent", (Throwable)exception);
                        }
                    }
                };
            }
            this.services.getConfigurationManager().addEventListener(ConfigurationEvent.ANY, this.configEventListener);
            this.services.getConfigurationManager().addReloadingEventListener(ReloadingEvent.ANY, this.configReloadListener);
        }
        catch (Exception exception) {
            logger.error("Error starting WebServer", (Throwable)exception);
        }
    }

    private void rateLimitedRestart() {
        logger.debug("rateLimitedRestart() - start");
        if (this.restartTimer == null || this.restartTimer.hasElapsed()) {
            this.restartTimer = new CountdownTimer(1L, TimeUnit.SECONDS);
            this.services.getThreadService().execute(new RestartSNMPTask(this.restartTimer, this));
        } else {
            this.restartTimer.reset();
        }
    }

    public synchronized void stop() {
        logger.info("stop() - start");
        try {
            this.services.getConfigurationManager().removeEventListener(ConfigurationEvent.SET_PROPERTY, this.configEventListener);
            this.services.getConfigurationManager().removeReloadingEventListener(ReloadingEvent.ANY, this.configReloadListener);
            if (this.theWebServerThread != null) {
                this.theWebServerThread.terminate();
                this.theWebServerThread = null;
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }

    public void setDataSource(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
        M11Servlet.setDataSource(this.theDataSource);
        if (this.SNMPAgent != null) {
            this.SNMPAgent.setDataSource(iDataSource);
        }
        this.services.getAnalyticsService().setDataSource(iDataSource);
    }

    public GetResult get(ObjectId objectId) throws InvalidObjectIdException, CommunicationException {
        throw new InvalidObjectIdException("This component does not support this get type");
    }

    public GetResult get(ObjectId objectId, int n) throws InvalidObjectIdException, CommunicationException {
        throw new InvalidObjectIdException("This component does not support this get type");
    }

    public GetResult get(ObjectId objectId, Object object) throws InvalidObjectIdException, CommunicationException, InvalidValueException {
        throw new InvalidObjectIdException("This component does not support this get type");
    }

    public Enumeration<ObjectId> getSupportedOids() {
        Enumeration<ObjectId> enumeration = null;
        if (this.theSupportedOids != null) {
            enumeration = this.theSupportedOids.elements();
        }
        return enumeration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SetResult set(ObjectId objectId, Object object) throws InvalidValueException, InvalidObjectIdException, CommunicationException {
        SetResult setResult = new SetResult();
        if (objectId == null || !objectId.equals((Object)WebServerGroup.SSLEnabled.getObjectId())) throw new InvalidObjectIdException();
        if (object == null || !(object instanceof Boolean)) throw new InvalidValueException();
        boolean bl = (Boolean)object;
        try {
            if (bl == M11Servlet.getSslEnabled()) {
                if (M11Servlet.isWebUIProtocolChangePending()) {
                    this.saveSSLEnabled(bl);
                    this.setProtocolChangePending(false);
                    M11Servlet.setWebUIProtocolChangePending(false);
                }
            } else if (!M11Servlet.isWebUIProtocolChangePending()) {
                this.saveSSLEnabled(bl);
                this.setProtocolChangePending(true);
                M11Servlet.setWebUIProtocolChangePending(true);
            }
            setResult.setSuccessful(true);
            return setResult;
        }
        catch (Exception exception) {}
        return setResult;
    }

    private void saveSSLEnabled(boolean bl) {
        String string = this.getProtocolString(bl);
        this.services.getConfigurationManager().setProperty("Networking", "protocol", string);
    }

    private void toggleGuiLaunchCommand() {
        File file = new File("gui.cmd");
        File file2 = new File("gui.bat");
        File file3 = new File("gui.ssl");
        File file4 = new File("gui.std");
        if (file.exists()) {
            if (this.theWebServerSettings.getSslEnabled() && file3.exists()) {
                if (!file.renameTo(file4)) {
                    logger.info("Failed to rename file: " + file4.getName());
                }
                if (!file3.renameTo(file)) {
                    logger.info("Failed to rename file: " + file.getName());
                }
            }
            if (!this.theWebServerSettings.getSslEnabled() && file4.exists()) {
                if (!file.renameTo(file3)) {
                    logger.info("Failed to rename file: " + file3.getName());
                }
                if (!file4.renameTo(file)) {
                    logger.info("Failed to rename file: " + file.getName());
                }
            }
        }
        if (file2.exists()) {
            if (this.theWebServerSettings.getSslEnabled() && file3.exists()) {
                if (!file2.renameTo(file4)) {
                    logger.info("Failed to rename file: " + file4.getName());
                }
                if (!file3.renameTo(file2)) {
                    logger.info("Failed to rename file: " + file2.getName());
                }
            }
            if (!this.theWebServerSettings.getSslEnabled() && file4.exists()) {
                if (!file2.renameTo(file3)) {
                    logger.info("Failed to rename file: " + file3.getName());
                }
                if (!file4.renameTo(file2)) {
                    logger.info("Failed to rename file: " + file2.getName());
                }
            }
        }
    }

    private void loadConfiguration() {
        logger.info("loadConfiguration() - start");
        int n = this.services.getVirtualConfigurationManager().getHttpPort();
        logger.debug("Setting Webserver HTTP port to: " + n);
        this.theWebServerSettings.setHTTPPort(n);
        n = this.services.getVirtualConfigurationManager().getHttpsPort();
        logger.debug("Setting Webserver HTTPS port to: " + n);
        this.theWebServerSettings.setHTTPSPort(n);
        this.setProtocol(this.services.getVirtualConfigurationManager().getProtocol());
    }

    private void setProtocol(String string) {
        boolean bl = "https".equalsIgnoreCase(string);
        if (this.theWebServerSettings.getSslEnabled() != bl) {
            this.theWebServerSettings.setSslEnabled(bl);
            M11Servlet.setSslEnabled(this.theWebServerSettings.getSslEnabled());
            this.toggleGuiLaunchCommand();
        }
    }

    private String getProtocolString(boolean bl) {
        return bl ? "https" : "http";
    }
}

