/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import java.io.Serializable;
import java.text.MessageFormat;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebServerSettings
implements Serializable {
    private static final long serialVersionUID = -5213784699799055289L;
    private int theHTTPPort = 3052;
    private int theHTTPSPort = 6547;
    private int theMaxIdleTime = 30000;
    private boolean theSslEnabledFlag = true;
    private String theKeystorePath = "keystore";
    private String theKeystorePassword = null;
    private String theWebRootPath = "comp/http/html";
    private String defaultSecurityProvider = "SUN";
    private String defaultKeyStoreType = "JKS";
    private String securityProvider = this.defaultSecurityProvider;
    private String keyStoreType = this.defaultKeyStoreType;
    private static final transient Logger logger = LogManager.getLogger(WebServerSettings.class);
    private ServiceManager services;

    public WebServerSettings(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    public boolean setHTTPPort(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 65535) {
            logger.debug("Setting Webserver HTTP port to: " + n);
            this.theHTTPPort = n;
            bl = true;
        }
        return bl;
    }

    public int getHTTPPort() {
        return this.theHTTPPort;
    }

    public boolean setHTTPSPort(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 65535) {
            logger.debug("Setting Webserver HTTPS port to: " + n);
            this.theHTTPSPort = n;
            bl = true;
        }
        return bl;
    }

    public int getHTTPSPort() {
        return this.theHTTPSPort;
    }

    public boolean setMaxIdleTime(int n) {
        boolean bl = false;
        if (n >= 0) {
            this.theMaxIdleTime = n;
            bl = true;
        }
        return bl;
    }

    public int getMaxIdleTime() {
        return this.theMaxIdleTime;
    }

    public void setSslEnabled(boolean bl) {
        logger.debug("Setting Webserver SSL Enabled flag to " + bl);
        this.theSslEnabledFlag = bl;
    }

    public boolean getSslEnabled() {
        return this.theSslEnabledFlag;
    }

    public boolean setKeystorePath(String string) {
        boolean bl = false;
        if (string != null && !string.isEmpty()) {
            logger.debug("Setting Webserver keystore path to " + string);
            this.theKeystorePath = string;
        }
        return bl;
    }

    public String getKeystorePath() {
        return this.theKeystorePath;
    }

    public void setKeystorePassword(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            logger.debug("setKeystorePassword() - setting a new keystore password");
            this.theKeystorePassword = string;
        }
        logger.debug("setKeystorePassword() - Password set: {}", (Object)StringUtils.isNotBlank((CharSequence)this.theKeystorePassword));
    }

    public String getKeystorePassword() {
        return this.theKeystorePassword;
    }

    public boolean setWebRootPath(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            logger.debug("Setting Webserver Root Path to " + string);
            this.theWebRootPath = string;
        }
        return bl;
    }

    public String getWebRootPath() {
        return this.theWebRootPath;
    }

    public String getHTTPSServerAddress() {
        logger.debug("getHTTPSServerAddress() - start");
        String string = null;
        try {
            string = this.services.getConfigurationManager().getString("Networking", "localHostAddress");
            if (StringUtils.isBlank((CharSequence)string)) {
                logger.debug("getHTTPSServerAddress() - Configuration value is blank, looking up FQDN for localhost");
                string = Utils.getFQDNForLocalHostAddress(null);
            }
        }
        catch (ConversionException conversionException) {
            logger.debug("getHTTPSServerAddress() - ConversionException: {}", (Throwable)conversionException);
            string = Utils.getFQDNForLocalHostAddress(null);
        }
        String string2 = MessageFormat.format("https://{0}:{1}", string, this.getHTTPSPort());
        logger.debug("getHTTPSServerAddress() - server address: {}", (Object)string2);
        return string2;
    }

    @Generated
    public String getDefaultSecurityProvider() {
        return this.defaultSecurityProvider;
    }

    @Generated
    public String getDefaultKeyStoreType() {
        return this.defaultKeyStoreType;
    }

    @Generated
    public String getSecurityProvider() {
        return this.securityProvider;
    }

    @Generated
    public void setSecurityProvider(String string) {
        this.securityProvider = string;
    }

    @Generated
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @Generated
    public void setKeyStoreType(String string) {
        this.keyStoreType = string;
    }
}

