/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver;

import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.components.stdpowersource.CommunicationsStatusLogEntry;
import com.apcc.m11.components.webserver.APCErrorHandler;
import com.apcc.m11.components.webserver.WebServerSettings;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardFactory;
import com.apcc.m11.components.webserver.filters.AccessControlAllowOriginFilter;
import com.apcc.m11.components.webserver.filters.ContentSecurityPolicyFilter;
import com.apcc.m11.components.webserver.filters.ContentTypeFilter;
import com.apcc.m11.components.webserver.filters.HeaderFilter;
import com.apcc.m11.components.webserver.filters.ReferrerPolicyFilter;
import com.apcc.m11.components.webserver.filters.StrictTransportSecurityFilter;
import com.apcc.m11.components.webserver.filters.XContentTypeOptionsFilter;
import com.apcc.m11.components.webserver.filters.XXSSProtectionFilter;
import com.apcc.m11.components.webserver.pages.AJAXCheckNutanixHostDetails;
import com.apcc.m11.components.webserver.servlets.AJAXAbout;
import com.apcc.m11.components.webserver.servlets.AJAXCfgWizApplySOGStatus;
import com.apcc.m11.components.webserver.servlets.AJAXCfgWizApplyStatus;
import com.apcc.m11.components.webserver.servlets.AJAXCfgWizConnectButton;
import com.apcc.m11.components.webserver.servlets.AJAXCfgWizSetOGButton;
import com.apcc.m11.components.webserver.servlets.AJAXCfgWizUPSConfig;
import com.apcc.m11.components.webserver.servlets.AJAXCheckFileExists;
import com.apcc.m11.components.webserver.servlets.AJAXCheckHostConnection;
import com.apcc.m11.components.webserver.servlets.AJAXCheckPassword;
import com.apcc.m11.components.webserver.servlets.AJAXCheckPortInUse;
import com.apcc.m11.components.webserver.servlets.AJAXCheckUpdates;
import com.apcc.m11.components.webserver.servlets.AJAXConnectedServers;
import com.apcc.m11.components.webserver.servlets.AJAXEventLog;
import com.apcc.m11.components.webserver.servlets.AJAXHostNMCMapping;
import com.apcc.m11.components.webserver.servlets.AJAXPrioritizedVM;
import com.apcc.m11.components.webserver.servlets.AJAXSendTestTrap;
import com.apcc.m11.components.webserver.servlets.AJAXSimplivityCheckPassword;
import com.apcc.m11.components.webserver.servlets.AJAXSimplivityOVCFinder;
import com.apcc.m11.components.webserver.servlets.AJAXStatusIconTray;
import com.apcc.m11.components.webserver.servlets.AJAXTargetHostSelection;
import com.apcc.m11.components.webserver.servlets.AJAXVMCheckPassword;
import com.apcc.m11.components.webserver.servlets.AJAXisDRSFullyManaged;
import com.apcc.m11.components.webserver.servlets.AdvancedSSHSettingsServlet;
import com.apcc.m11.components.webserver.servlets.AdvancedShutdown;
import com.apcc.m11.components.webserver.servlets.AjaxSSHSettingsServlet;
import com.apcc.m11.components.webserver.servlets.CEIPServlet;
import com.apcc.m11.components.webserver.servlets.CfgLogEvent;
import com.apcc.m11.components.webserver.servlets.CfgNotifyUsers;
import com.apcc.m11.components.webserver.servlets.CfgRunCommandFile;
import com.apcc.m11.components.webserver.servlets.CfgShutdown;
import com.apcc.m11.components.webserver.servlets.CheckNMCDetails;
import com.apcc.m11.components.webserver.servlets.Configure;
import com.apcc.m11.components.webserver.servlets.ConfigureHostNMCMapping;
import com.apcc.m11.components.webserver.servlets.ConfigureSNMPSettings;
import com.apcc.m11.components.webserver.servlets.ConfigureShutdownSettings;
import com.apcc.m11.components.webserver.servlets.ConfigureTargetHostSelection;
import com.apcc.m11.components.webserver.servlets.ConfigureVMSettings;
import com.apcc.m11.components.webserver.servlets.ConnectedServers;
import com.apcc.m11.components.webserver.servlets.ConnectionLogServlet;
import com.apcc.m11.components.webserver.servlets.DisplayEventDetails;
import com.apcc.m11.components.webserver.servlets.ErrorServlet;
import com.apcc.m11.components.webserver.servlets.EventLog;
import com.apcc.m11.components.webserver.servlets.EventLogDelete;
import com.apcc.m11.components.webserver.servlets.ExportLog;
import com.apcc.m11.components.webserver.servlets.Heartbeat;
import com.apcc.m11.components.webserver.servlets.Home;
import com.apcc.m11.components.webserver.servlets.HyperVVMSettings;
import com.apcc.m11.components.webserver.servlets.IndividualVMSettings;
import com.apcc.m11.components.webserver.servlets.Licensing;
import com.apcc.m11.components.webserver.servlets.LogBundle;
import com.apcc.m11.components.webserver.servlets.Login;
import com.apcc.m11.components.webserver.servlets.Logout;
import com.apcc.m11.components.webserver.servlets.NMCDetails;
import com.apcc.m11.components.webserver.servlets.NutanixSettings;
import com.apcc.m11.components.webserver.servlets.SSHSettingsServlet;
import com.apcc.m11.components.webserver.servlets.SelectEvents;
import com.apcc.m11.components.webserver.servlets.Updates;
import com.apcc.m11.components.webserver.servlets.VMPrioritization;
import com.apcc.m11.components.webserver.servlets.cfgwizard.CfgWizardServlet;
import com.apcc.m11.components.webserver.servlets.rest.CertificatesREST;
import com.apcc.m11.components.webserver.servlets.rest.JREUpdateREST;
import com.apcc.m11.components.webserver.servlets.rest.LicenseDetailsREST;
import com.apcc.m11.components.webserver.servlets.rest.LicensingOfflineREST;
import com.apcc.m11.components.webserver.servlets.rest.LicensingREST;
import com.apcc.m11.components.webserver.servlets.rest.LogBundleREST;
import com.apcc.m11.components.webserver.servlets.rest.RESTRemoteShutdownEvent;
import com.apcc.m11.components.webserver.servlets.rest.VCenterRootCertREST;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.oslogger.OperatingSystemEventLogger;
import com.apcc.pcns.util.CountdownTimer;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.ee8.nested.SessionHandler;
import org.eclipse.jetty.ee8.servlet.FilterHolder;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.ee8.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;

public class WebServerThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(WebServerThread.class);
    private static final String COOKIE_HOST_PREFIX = "__Host-";
    private WebServerSettings theWebServerSettings = null;
    private Server thePrimaryWebServer = null;
    private Object theDataLock = null;
    private static final String kTempPath = "temp";
    private static final String kTempPath1 = "temp1";
    private static final String kIbmX509 = "IbmX509";
    private final String TCP = "TCP";
    private Vector<CommunicationsStatusLogEntry> theStatusLog;
    private static int theStatusLogEntryId = 1;
    ResourceBundleWrapper bundle = null;
    private IPermanentStorage thePermanentStorage;
    private ServiceManager services;
    private OperatingSystemEventLogger osLogger;

    WebServerThread(@NonNull WebServerSettings webServerSettings, IPermanentStorage iPermanentStorage, @NonNull ServiceManager serviceManager) {
        if (webServerSettings == null) {
            throw new IllegalArgumentException("aWebServerSettings is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.osLogger = this.services.getOperatingSystemEventLogger();
        ServiceManager.getInstance().getProductVersion().setM11Storage(iPermanentStorage);
        this.theDataLock = new Object();
        this.theStatusLog = new Vector();
        this.theWebServerSettings = webServerSettings;
        this.thePermanentStorage = iPermanentStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Start web server");
        Object object = this.theDataLock;
        synchronized (object) {
            Timer timer;
            if (this.theWebServerSettings.getSslEnabled()) {
                try {
                    this.thePrimaryWebServer = new Server();
                    this.thePrimaryWebServer.addConnector(this.getSslSocketConnector());
                    this.thePrimaryWebServer.setErrorHandler((Request.Handler)new APCErrorHandler());
                    this.thePrimaryWebServer.setHandler((Supplier)this.getWebAppContext());
                    this.checkThreadPoolSize(this.thePrimaryWebServer);
                }
                catch (Throwable throwable) {
                    logger.error("Create server exception:", throwable);
                }
            } else {
                try {
                    this.thePrimaryWebServer = new Server();
                    timer = new ServerConnector(this.thePrimaryWebServer, 1, 1);
                    try {
                        timer.setPort(this.theWebServerSettings.getHTTPPort());
                        this.thePrimaryWebServer.addConnector((Connector)timer);
                        this.thePrimaryWebServer.setHandler((Supplier)this.getWebAppContext());
                        this.checkThreadPoolSize(this.thePrimaryWebServer);
                    }
                    finally {
                        timer.close();
                    }
                }
                catch (Exception exception) {
                    logger.error("Error while creating Server: ", (Throwable)exception);
                }
            }
            timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){
                boolean flag1 = false;

                @Override
                public void run() {
                    block6: {
                        if (!this.flag1) {
                            try {
                                Vector<Object> vector = new Vector<Object>();
                                vector.add("TCP");
                                vector.add(Integer.toString(WebServerThread.this.theWebServerSettings.getHTTPSPort()));
                                WebServerThread.this.logCommunicationStatusError("RegStatus.PowerChuteTry", vector);
                                if (WebServerThread.this.thePrimaryWebServer != null) {
                                    WebServerThread.this.thePrimaryWebServer.start();
                                }
                                logger.info("Server started");
                                this.flag1 = true;
                                WebServerThread.this.logCommunicationStatusError("RegStatus.PowerChuteSuccess", vector);
                            }
                            catch (Exception exception) {
                                if (exception instanceof IOException && exception.getCause() instanceof BindException) {
                                    Vector<Object> vector = new Vector<Object>();
                                    vector.add("TCP");
                                    vector.add(Integer.toString(WebServerThread.this.theWebServerSettings.getHTTPSPort()));
                                    WebServerThread.this.logCommunicationStatusError("RegStatus.PowerChuteError", vector);
                                    this.flag1 = false;
                                    WebServerThread.this.osLogger.fatal("OsLogger.WebserverPortBindingFailure", "104", WebServerThread.this.theWebServerSettings.getHTTPSPort());
                                    logger.fatal("Unable to bind to the PCNS port. Check that PCNS port {} is free {}", (Object)WebServerThread.this.theWebServerSettings.getHTTPSPort(), (Object)exception);
                                    break block6;
                                }
                                WebServerThread.this.osLogger.fatal("OsLogger.WebserverStartFailure", exception.getLocalizedMessage());
                                logger.fatal("Start server exception:", (Throwable)exception);
                            }
                        } else {
                            this.cancel();
                        }
                    }
                }
            }, 0L, TimeUnit.MILLISECONDS.convert(2L, TimeUnit.MINUTES));
            try {
                if (this.thePrimaryWebServer != null) {
                    while (!this.thePrimaryWebServer.isStarted()) {
                        logger.debug("Waiting for server to start - sleeping Thread for 500ms.");
                        new CountdownTimer(500L, TimeUnit.MILLISECONDS).await(this.theDataLock);
                        if (!this.thePrimaryWebServer.isStopping() && !this.thePrimaryWebServer.isStopped() && !this.thePrimaryWebServer.isFailed()) continue;
                        logger.debug("Server stopped or failed");
                    }
                    if (this.thePrimaryWebServer.isStarted()) {
                        WebAppContext webAppContext = (WebAppContext)this.thePrimaryWebServer.getHandler();
                        this.services.getApplicationSettings().setSessionTimeoutSeconds(webAppContext.getSessionHandler().getMaxInactiveInterval());
                        logger.info("Server join");
                        this.thePrimaryWebServer.join();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error("Join server exception:", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
            logger.info("Web server exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.theDataLock;
        synchronized (object) {
            try {
                if (this.thePrimaryWebServer != null) {
                    this.thePrimaryWebServer.stop();
                    this.thePrimaryWebServer = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void logCommunicationStatusError(String string, Vector<Object> vector) {
        CommunicationsStatusLogEntry communicationsStatusLogEntry = new CommunicationsStatusLogEntry(++theStatusLogEntryId, new Date(), null, string, vector);
        this.theStatusLog.add(communicationsStatusLogEntry);
        this.bundle = Utils.getWebServerResourceBundle(Locale.getDefault());
        this.services.getApplicationErrorHandler().put(communicationsStatusLogEntry.getLogMsg(this.bundle));
    }

    private WebAppContext getWebAppContext() {
        File file = new File(kTempPath);
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath("/");
        webAppContext.setWar(this.theWebServerSettings.getWebRootPath());
        webAppContext.setTempDirectory(file);
        SessionHandler sessionHandler = new SessionHandler();
        if (this.theWebServerSettings.getSslEnabled()) {
            sessionHandler.getSessionCookieConfig().setSecure(true);
        }
        sessionHandler.setSessionCookie(this.createRandomSessionParameter());
        sessionHandler.setHttpOnly(true);
        sessionHandler.setSameSite(HttpCookie.SameSite.STRICT);
        webAppContext.setSessionHandler(sessionHandler);
        String string = "/*";
        EnumSet<DispatcherType> enumSet = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE);
        webAppContext.addFilter(new FilterHolder((Filter)new XXSSProtectionFilter()), string, enumSet);
        webAppContext.addFilter(new FilterHolder((Filter)new HeaderFilter(this.services)), string, enumSet);
        webAppContext.addFilter(new FilterHolder((Filter)new StrictTransportSecurityFilter()), string, enumSet);
        webAppContext.addFilter(new FilterHolder((Filter)new AccessControlAllowOriginFilter()), string, enumSet);
        webAppContext.addFilter(new FilterHolder((Filter)new ContentTypeFilter()), string, enumSet);
        webAppContext.addFilter(new FilterHolder((Filter)new ContentSecurityPolicyFilter()), string, enumSet);
        webAppContext.addFilter(new FilterHolder((Filter)new XContentTypeOptionsFilter()), string, enumSet);
        webAppContext.addFilter(new FilterHolder((Filter)new ReferrerPolicyFilter()), string, enumSet);
        webAppContext.addServlet(new ServletHolder((Servlet)new Login(this.services)), "/login");
        webAppContext.addServlet(new ServletHolder((Servlet)new Logout(this.services)), "/logout");
        webAppContext.addServlet(new ServletHolder((Servlet)new Home(this.services)), "/index.html");
        webAppContext.addServlet(new ServletHolder((Servlet)new ErrorServlet(this.services)), "/error");
        webAppContext.addServlet(new ServletHolder((Servlet)new Configure(this.services)), "/configure");
        webAppContext.addServlet(new ServletHolder((Servlet)new Updates(this.services)), "/updates");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCheckUpdates(this.services)), "/AJAXCheckUpdates");
        webAppContext.addServlet(new ServletHolder((Servlet)new CEIPServlet(this.services)), "/ceip");
        webAppContext.addServlet(new ServletHolder((Servlet)new EventLog(this.services)), "/eventlog");
        webAppContext.addServlet(new ServletHolder((Servlet)new ConnectionLogServlet(this.services)), "/connectionlog");
        webAppContext.addServlet(new ServletHolder((Servlet)new CfgNotifyUsers(this.services)), "/cfgnotifyusers");
        webAppContext.addServlet(new ServletHolder((Servlet)new CfgShutdown(this.services)), "/cfgshutdown");
        webAppContext.addServlet(new ServletHolder((Servlet)new CfgLogEvent(this.services)), "/cfglogevent");
        webAppContext.addServlet(new ServletHolder((Servlet)new CfgRunCommandFile(this.services)), "/cfgruncmdfile");
        webAppContext.addServlet(new ServletHolder((Servlet)new SelectEvents(this.services)), "/selectevents");
        webAppContext.addServlet(new ServletHolder((Servlet)new ConfigureShutdownSettings(this.services)), "/configureshutdownsettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new ConfigureSNMPSettings(this.thePermanentStorage, this.services)), "/configuresnmpsettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new AdvancedShutdown(this.services)), "/advancedshutdown");
        webAppContext.addServlet(new ServletHolder((Servlet)new ConfigureVMSettings(this.services)), "/vmsettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new IndividualVMSettings(this.services)), "/individualvmsettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new ConfigureTargetHostSelection(this.services)), "/targethostselection");
        webAppContext.addServlet(new ServletHolder((Servlet)new ConfigureHostNMCMapping(this.services)), "/hostnmcmapping");
        webAppContext.addServlet(new ServletHolder((Servlet)new VMPrioritization(this.services)), "/vmprioritization");
        webAppContext.addServlet(new ServletHolder((Servlet)new NMCDetails(this.services)), "/upsconfig");
        webAppContext.addServlet(new ServletHolder((Servlet)new ConnectedServers(this.services)), "/ConnectedServers");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXConnectedServers(this.services)), "/AJAXConnectedServers");
        webAppContext.addServlet(new ServletHolder((Servlet)new DisplayEventDetails(this.services)), "/DisplayEventDetails");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXEventLog(this.services)), "/AJAXLog");
        webAppContext.addServlet(new ServletHolder((Servlet)new EventLogDelete(this.services)), "/eventlogdelete");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCfgWizConnectButton(this.services)), "/AJAXConnectButton");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCfgWizSetOGButton(this.services)), "/AJAXSetOGButton");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCfgWizApplyStatus(this.services)), "/AJAXApplyStatus");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCfgWizApplySOGStatus(this.services)), "/AJAXApplySOGStatus");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXStatusIconTray(this.services)), "/AJAXStatusIconTray");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCfgWizUPSConfig(this.services)), "/AJAXCfgWizUPSConfig");
        webAppContext.addServlet(new ServletHolder((Servlet)new ExportLog(this.services)), "/ExportLog");
        webAppContext.addServlet(new ServletHolder((Servlet)new CheckNMCDetails(this.services)), "/CheckNMCDetails");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCheckPassword(this.services)), "/checkaccess");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXVMCheckPassword(this.services)), "/checkvmaccess");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXSimplivityCheckPassword(this.services)), "/checksimplivityaccess");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCheckFileExists(this.services)), "/verifyfile");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXSendTestTrap(this.thePermanentStorage, this.services)), "/testTrap");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCheckHostConnection(this.services)), "/AJAXCheckHostConnection");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXPrioritizedVM(this.services)), "/ajaxvmlist");
        webAppContext.addServlet(new ServletHolder((Servlet)new HyperVVMSettings(this.services)), "/HyperVVMSettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXTargetHostSelection(this.services)), "/AJAXTargetHostSelection");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXisDRSFullyManaged(this.services)), "/AJAXisDRSFullyManaged");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXHostNMCMapping(this.services)), "/AJAXHostNMCMapping");
        webAppContext.addServlet(new ServletHolder((Servlet)new NutanixSettings(this.services)), "/NutanixSettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new SSHSettingsServlet(this.thePermanentStorage, this.services)), "/sshsettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new AdvancedSSHSettingsServlet(this.thePermanentStorage, this.services)), "/advancedsshsettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new AjaxSSHSettingsServlet(this.thePermanentStorage, this.services)), "/AJAXSshSettings");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCheckNutanixHostDetails(this.services)), "/AJAXCheckNutanixHostDetails");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXCheckPortInUse(this.services)), "/checkPort");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXSimplivityOVCFinder(this.services)), "/ovcfinder");
        webAppContext.addServlet(new ServletHolder((Servlet)new AJAXAbout(this.services)), "/about");
        if (!this.services.getWebServerUtils().isJapanese()) {
            webAppContext.addServlet(new ServletHolder((Servlet)new Licensing(this.services)), "/licensing");
        }
        webAppContext.addServlet(new ServletHolder((Servlet)new LogBundle(this.services)), "/logBundle");
        webAppContext.addServlet(new ServletHolder((Servlet)new RESTRemoteShutdownEvent(this.services)), "/REST/remoteShutdown");
        webAppContext.addServlet(new ServletHolder((Servlet)new JREUpdateREST(this.services)), "/REST/updateJRE");
        webAppContext.addServlet(new ServletHolder((Servlet)new LicensingREST(this.services)), "/REST/licensing/license");
        webAppContext.addServlet(new ServletHolder((Servlet)new LicenseDetailsREST(this.services)), "/REST/licensing/details");
        webAppContext.addServlet(new ServletHolder((Servlet)new LicensingOfflineREST(this.services)), "/REST/licensing/offline");
        webAppContext.addServlet(new ServletHolder((Servlet)new CertificatesREST(this.services)), "/REST/Certificates");
        webAppContext.addServlet(new ServletHolder((Servlet)new VCenterRootCertREST(this.services)), "/REST/VCenterRootCert");
        webAppContext.addServlet(new ServletHolder((Servlet)new LogBundleREST(this.services)), "/REST/logBundle");
        String string2 = System.getProperty("disableHeartbeat");
        if (!StringUtils.equals((CharSequence)string2, (CharSequence)"1")) {
            webAppContext.addServlet(new ServletHolder((Servlet)new Heartbeat(this.services)), "/Heartbeat");
        }
        webAppContext.addServlet(new ServletHolder((Servlet)new CfgWizardServlet(this.services, new CfgWizardFactory())), "/cfgwizard");
        return webAppContext;
    }

    private Connector getSslSocketConnector() {
        SslContextFactory.Server server = new SslContextFactory.Server();
        server.addExcludeProtocols(new String[]{"SSLv3"});
        server.setKeyStorePath(this.theWebServerSettings.getKeystorePath());
        server.setKeyStorePassword(this.theWebServerSettings.getKeystorePassword());
        server.setKeyStoreProvider(this.theWebServerSettings.getSecurityProvider());
        server.setKeyStoreType(this.theWebServerSettings.getKeyStoreType());
        server.setKeyManagerPassword(this.theWebServerSettings.getKeystorePassword());
        server.setTrustStorePath(this.theWebServerSettings.getKeystorePath());
        server.setTrustStorePassword(this.theWebServerSettings.getKeystorePassword());
        server.setRenegotiationAllowed(false);
        SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
        secureRequestCustomizer.setSniHostCheck(false);
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
        httpConfiguration.setSecurePort(this.theWebServerSettings.getHTTPSPort());
        httpConfiguration.setSecureScheme("https");
        httpConfiguration.setSendServerVersion(false);
        httpConfiguration.setSendXPoweredBy(false);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfiguration);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(server, httpConnectionFactory.getProtocol());
        int n = 1;
        int n2 = 1;
        ServerConnector serverConnector = new ServerConnector(this.thePrimaryWebServer, null, null, null, n, n2, new ConnectionFactory[]{sslConnectionFactory, httpConnectionFactory});
        serverConnector.setPort(this.theWebServerSettings.getHTTPSPort());
        serverConnector.setIdleTimeout((long)this.theWebServerSettings.getMaxIdleTime());
        String string = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        logger.info("algorithm :" + string);
        if (string.equalsIgnoreCase(kIbmX509)) {
            server.setKeyManagerFactoryAlgorithm(kIbmX509);
            server.setTrustManagerFactoryAlgorithm(kIbmX509);
            logger.info(server.getKeyManagerFactoryAlgorithm());
            logger.info(server.getTrustManagerFactoryAlgorithm());
        }
        String[] stringArray = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_PSK_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_PSK_WITH_AES_128_GCM_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"};
        server.setIncludeCipherSuites(stringArray);
        return serverConnector;
    }

    private String createRandomSessionParameter() {
        SecureRandom secureRandom = new SecureRandom();
        return COOKIE_HOST_PREFIX + Long.toHexString(secureRandom.nextLong());
    }

    private void checkThreadPoolSize(Server server) {
        if (server != null) {
            ThreadPool.SizedThreadPool sizedThreadPool = (ThreadPool.SizedThreadPool)server.getThreadPool();
            int n = sizedThreadPool == null ? -1 : sizedThreadPool.getMaxThreads();
            int n2 = 1;
            for (Connector connector : server.getConnectors()) {
                if (connector instanceof AbstractConnector) {
                    n2 += ((AbstractConnector)connector).getAcceptors();
                }
                if (!(connector instanceof ServerConnector)) continue;
                n2 += ((ServerConnector)connector).getSelectorManager().getSelectorCount();
            }
            logger.debug("checkThreadPoolSize: poolMax: {} needed: {}", (Object)n, (Object)n2);
            if (n > 0 && n2 > n) {
                sizedThreadPool.setMaxThreads(n2 + n);
                logger.debug("checkThreadPoolSize: set maxThreads to: {}", (Object)sizedThreadPool.getMaxThreads());
            }
        }
    }
}

