/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.certificates;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class SelfSignedCertGenerator {
    private static final Logger LOGGER = LogManager.getLogger(SelfSignedCertGenerator.class);
    private static int MAX_CERTIFICATE_VALIDITY_PERIOD = 1;
    private static final int kCertificateEncryptionSize = 4096;
    private static final String kRSA = "RSA";
    private static final String kAlgorithmToUse = "SHA256withRSA";
    private KeyPair certKeyPair;
    private String organisation = "";
    private String organisationUnit = "";
    private String country = "JP";
    private String state = "Tokyo";
    private String locality = "Tokyo";
    private String defaultFQDN;
    private String subjectCommonName = "APC Software Application";
    private String issuerCommonName = "APC Software";

    public SelfSignedCertGenerator(String string, String string2, String string3, String string4) {
        this();
        this.setSubjectCommonName(string);
        this.issuerCommonName = string2;
        this.setOrganisation(string3);
        this.setOrganisationUnit(string4);
    }

    public SelfSignedCertGenerator() {
    }

    public X509Certificate getSelfSignedCertificate() {
        X509Certificate x509Certificate = null;
        this.certKeyPair = this.generateKeyPair(kRSA, 4096);
        if (this.certKeyPair != null) {
            String string = this.getServerFQDN();
            LOGGER.debug("SelfSignedCertGenerator.getSelfSignedCert() - Generating cert for common name: {}", (Object)string);
            try {
                x509Certificate = this.generateCert(this.subjectCommonName, this.getServerFQDN(), this.issuerCommonName, this.organisation, this.organisationUnit, this.locality, this.state, this.country, this.certKeyPair);
            }
            catch (Exception exception) {
                LOGGER.debug("SelfSignedCertGenerator.getSelfSignedCert() error:", (Throwable)exception);
            }
        }
        return x509Certificate;
    }

    private KeyPair generateKeyPair(String string, int n) {
        KeyPair keyPair = null;
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
            SecureRandom secureRandom = SecureRandom.getInstance("DRBG");
            keyPairGenerator.initialize(n, secureRandom);
            keyPair = keyPairGenerator.generateKeyPair();
        }
        catch (Exception exception) {
            LOGGER.debug("SelfSignedCertGenerator.generatekeyPair() KeyPairGenerator exception=", (Throwable)exception);
        }
        return keyPair;
    }

    private String getServerFQDN() {
        String string = this.defaultFQDN;
        try {
            string = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.debug("Got and UnknownHostException when trying to retrieve the Local Host.", (Throwable)unknownHostException);
        }
        return string;
    }

    private X509Certificate generateCert(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, KeyPair keyPair) throws InvalidKeyException, SecurityException, SignatureException {
        X509Certificate x509Certificate = null;
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis();
        calendar.add(1, MAX_CERTIFICATE_VALIDITY_PERIOD);
        long l2 = calendar.getTimeInMillis();
        Date date = new Date(l);
        Date date2 = new Date(l2);
        BigInteger bigInteger = BigInteger.valueOf(System.currentTimeMillis());
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, string3);
        x500NameBuilder.addRDN(BCStyle.OU, string5);
        x500NameBuilder.addRDN(BCStyle.O, string4);
        x500NameBuilder.addRDN(BCStyle.L, string6);
        x500NameBuilder.addRDN(BCStyle.ST, string7);
        x500NameBuilder.addRDN(BCStyle.C, string8);
        X500NameBuilder x500NameBuilder2 = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder2.addRDN(BCStyle.CN, string3);
        x500NameBuilder2.addRDN(BCStyle.OU, string5);
        x500NameBuilder2.addRDN(BCStyle.O, string4);
        x500NameBuilder2.addRDN(BCStyle.L, string6);
        x500NameBuilder2.addRDN(BCStyle.ST, string7);
        x500NameBuilder2.addRDN(BCStyle.C, string8);
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder(kAlgorithmToUse).build(keyPair.getPrivate());
            JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500NameBuilder.build(), bigInteger, date, date2, x500NameBuilder2.build(), keyPair.getPublic());
            X509CertificateHolder x509CertificateHolder = jcaX509v3CertificateBuilder.build(contentSigner);
            JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
            x509Certificate = jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
            LOGGER.debug("SelfSignedCertGenerator.generateCert() - Verifying Cert.");
            x509Certificate.verify(x509Certificate.getPublicKey());
            LOGGER.debug("SelfSignedCertGenerator.generateCert() - Cert is valid.");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertificateException | OperatorCreationException throwable) {
            LOGGER.error("Error ereating self signed cert:", throwable);
        }
        return x509Certificate;
    }

    public KeyPair getCertKeyPair() {
        return this.certKeyPair;
    }

    public void setOrganisation(String string) {
        this.organisation = string;
    }

    public void setOrganisationUnit(String string) {
        this.organisationUnit = string;
    }

    public void setCountry(String string) {
        this.country = string;
    }

    public void setState(String string) {
        this.state = string;
    }

    public void setLocality(String string) {
        this.locality = string;
    }

    public void setDefaultFQDN(String string) {
        this.defaultFQDN = string;
    }

    public String getSubjectCommonName() {
        return this.subjectCommonName;
    }

    public void setSubjectCommonName(String string) {
        this.subjectCommonName = string;
    }
}

