/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.certificates;

import com.apcc.m11.components.webserver.WebServerSettings;
import com.apcc.m11.components.webserver.certificates.SelfSignedCertGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WebserverCertificateManager {
    private static final transient Logger logger = LogManager.getLogger(WebserverCertificateManager.class);
    private static final String kKeystoreDefault = "keystore";
    private static final String kKeystoreDirectory = "/etc/";
    private static final String kJettyHome = "jetty.home";
    private SelfSignedCertGenerator selfSignedCertGenerator;
    private File keystoreFile = null;
    private KeyStore keystore = null;
    private String keystorePath = "keystore";
    private String keystoreAlias = "securekey";
    private String passPhrase;

    public WebserverCertificateManager() {
        String string = System.getProperty(kJettyHome);
        this.keystoreFile = string != null ? new File(string + kKeystoreDirectory + this.keystorePath) : new File(this.keystorePath);
        logger.debug("WebserverCertificateManager() - Using Keystore file: {}", (Object)this.keystoreFile.getAbsolutePath());
    }

    public void createKeystore(@NonNull WebServerSettings webServerSettings) {
        if (webServerSettings == null) {
            throw new IllegalArgumentException("webServerSettings is marked non-null but is null");
        }
        this.keystore = this.loadKeystore(webServerSettings);
    }

    public synchronized boolean updateKeystore(String string, @NonNull WebServerSettings webServerSettings) {
        if (webServerSettings == null) {
            throw new IllegalArgumentException("webServerSettings is marked non-null but is null");
        }
        boolean bl = false;
        this.keystore = this.loadKeystore(webServerSettings);
        if (this.keystore != null) {
            try {
                KeyStore.Entry entry = this.keystore.getEntry(this.keystoreAlias, new KeyStore.PasswordProtection(this.passPhrase.toCharArray()));
                if (entry != null) {
                    this.keystore.setEntry(this.keystoreAlias, entry, new KeyStore.PasswordProtection(string.toCharArray()));
                }
                this.setPassPhrase(string);
                this.saveKeystore();
                bl = true;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException exception) {
                logger.error((Object)exception);
            }
        }
        return bl;
    }

    public void setSelfSignedCertGenerator(SelfSignedCertGenerator selfSignedCertGenerator) {
        this.selfSignedCertGenerator = selfSignedCertGenerator;
    }

    public X509Certificate getServerCertificate() {
        X509Certificate x509Certificate = null;
        x509Certificate = this.checkCertificateInKeystore(this.keystoreAlias);
        if (x509Certificate == null) {
            if (this.addSelfSignedCertToKeystore(this.keystoreAlias)) {
                x509Certificate = this.getServerCertificate();
            } else {
                logger.debug("SecurityCertificateManager - Failed to add self signed certificate to keystore");
            }
        }
        return x509Certificate;
    }

    private boolean addSelfSignedCertToKeystore(String string) {
        boolean bl = false;
        try {
            X509Certificate x509Certificate = this.selfSignedCertGenerator.getSelfSignedCertificate();
            if (this.keystore != null) {
                KeyPair keyPair = this.selfSignedCertGenerator.getCertKeyPair();
                if (keyPair != null) {
                    this.keystore.setKeyEntry(string, keyPair.getPrivate(), this.passPhrase.toCharArray(), new X509Certificate[]{x509Certificate});
                }
                logger.debug("addSelfSignedCertToKeystore()  - Attempted to add cert for:" + string);
                this.saveKeystore();
                if (this.checkCertificateInKeystore(string) != null) {
                    logger.debug("addSelfSignedCertToKeystore() - verified cert added for: {}", (Object)string);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            logger.debug("addCertToKeystore - Exception:", (Throwable)exception);
        }
        return bl;
    }

    private X509Certificate checkCertificateInKeystore(String string) {
        X509Certificate x509Certificate = null;
        if (string == null) {
            return x509Certificate;
        }
        try {
            if (this.keystore != null && this.keystore.containsAlias(string)) {
                logger.debug("checkCertificateInKeystore - alias found in keystore:" + string);
                x509Certificate = (X509Certificate)this.keystore.getCertificate(string);
            }
        }
        catch (Exception exception) {
            logger.debug("checkCertificateInKeystore - Exception: ", (Throwable)exception);
        }
        return x509Certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeystore(@NonNull WebServerSettings webServerSettings) {
        if (webServerSettings == null) {
            throw new IllegalArgumentException("webServerSettings is marked non-null but is null");
        }
        KeyStore keyStore = null;
        String string = null;
        String string2 = null;
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        if (this.keystoreFile.exists()) {
            try {
                keyStore = KeyStore.getInstance(this.keystoreFile, this.passPhrase.toCharArray());
                string = keyStore.getProvider().getName();
                webServerSettings.setSecurityProvider(string);
                string2 = keyStore.getType();
                webServerSettings.setKeyStoreType(string2);
                logger.debug("loadKeystore() - provider: {} type: {}", (Object)string, (Object)string2);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                logger.error("loadKeystore() - Problem loading keystore, deleting existing keystore, error: {}", (Throwable)exception);
                try {
                    this.keystoreFile.delete();
                }
                catch (Exception exception2) {
                    logger.error("loadKeystore() - Problem deleting keystore, error: {}", (Throwable)exception2);
                }
            }
        }
        if (keyStore == null) {
            string = webServerSettings.getDefaultSecurityProvider();
            string2 = webServerSettings.getDefaultKeyStoreType();
            logger.debug("loadKeystore() - No keystore set, using default provider {} with default keystore type {}.", (Object)string, (Object)string2);
            try {
                keyStore = KeyStore.getInstance(string2, string);
                webServerSettings.setKeyStoreType(string2);
                webServerSettings.setSecurityProvider(string);
            }
            catch (SecurityException | KeyStoreException | NoSuchProviderException exception) {
                logger.error("loadKeystore() - Failed creating keystore: ", (Throwable)exception);
            }
        }
        if (keyStore != null) {
            if (this.keystoreFile.exists()) {
                var6_8 = null;
                try {
                    var6_8 = new FileInputStream(this.keystoreFile);
                    keyStore.load((InputStream)var6_8, this.passPhrase.toCharArray());
                }
                catch (CertificateException certificateException) {
                    logger.debug((Object)certificateException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    logger.debug("loadKeystore() - NoSuchAlgorithm:", (Throwable)noSuchAlgorithmException);
                }
                catch (IOException iOException) {
                    if (iOException.getCause() instanceof UnrecoverableKeyException) {
                        logger.debug("loadKeystore() - Password Error:", (Throwable)iOException);
                    }
                    logger.debug((Object)iOException);
                }
                finally {
                    if (var6_8 != null) {
                        try {
                            ((InputStream)var6_8).close();
                        }
                        catch (IOException iOException) {
                            logger.debug("Tried to close, but failed");
                        }
                    }
                }
            } else {
                var6_8 = null;
                try {
                    keyStore.load(null, null);
                    var6_8 = new FileOutputStream(this.keystoreFile);
                    keyStore.store((OutputStream)var6_8, this.passPhrase.toCharArray());
                    ((OutputStream)var6_8).flush();
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                    logger.error((Object)exception);
                }
                finally {
                    if (var6_8 != null) {
                        try {
                            ((FileOutputStream)var6_8).close();
                        }
                        catch (IOException iOException) {
                            logger.debug("Tried to close, but failed");
                        }
                    }
                }
            }
        }
        return keyStore;
    }

    private synchronized void saveKeystore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.keystoreFile);
        this.keystore.store(fileOutputStream, this.passPhrase.toCharArray());
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    public void setPassPhrase(String string) {
        this.passPhrase = string;
    }
}

