/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLDebug;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.ApplyButton;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import java.util.Vector;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CfgWizardPage
implements HTML {
    public static final String kPageDesc = ".PageDescription";
    private static final String kNextId = "CfgWizard.Next";
    private static final String kPageTitle = ".PageTitle";
    private static final String kPreviousId = "CfgWizard.Previous";
    private static final String kProductId = "Login.Product";
    private static final String kTitleId = "CfgWizard.Title";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    protected static final String kCancelId = "CfgWizard.Cancel";
    private static final Logger logger = LogManager.getLogger(CfgWizardPage.class);
    private String thePreviousText;
    private String theProductText;
    private String theTitleText;
    private ApcSectionHeader hdr = null;
    private String theWaitText;
    protected String theWaitTitle;
    protected ApplyButton cancelBtn = new ApplyButton("cancel");
    protected ApplyButton nextBtn = new ApplyButton("next");
    protected ApplyButton prevBtn = new ApplyButton("previous");
    protected String theCancelText;
    protected String theNextText;
    protected ApcPage thePage;
    protected String thePageDesc;
    protected String thePageTitle;
    protected ServiceManager services;
    private String action = "/cfgwizard";
    protected VMWareConnection vmwareConnection;
    private boolean configComplete;

    public CfgWizardPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.thePage = new ApcPage(true, false, this.services);
        this.configComplete = serviceManager.getVirtualConfigurationManager().isConfigWizardComplete();
    }

    public static boolean hasSOGs(PageContext pageContext) {
        Vector vector;
        boolean bl = false;
        Object object = pageContext.get(TCPIPCommunication.OutletGroupList.getObjectId());
        if (object instanceof Vector && !(vector = (Vector)object).isEmpty()) {
            Object e = vector.get(0);
            if (e instanceof Vector) {
                Vector vector2 = (Vector)object;
                for (Vector vector3 : vector2) {
                    if (vector3 == null || vector3.size() <= 0) continue;
                    bl = true;
                }
            } else {
                Vector vector4 = (Vector)object;
                if (vector4 != null && vector4.size() > 0) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        this.setupLanguage(pageContext.getLocale());
        this.thePage.addStyleSheet("styles/cfgWizard.css");
        this.thePage.addScript("scripts/cfgWizard.js");
        this.thePage.addScript("scripts/navigation.js");
        this.thePage.addTitle(this.theProductText);
        HTMLTagWithClassStyle hTMLTagWithClassStyle = new HTMLTagWithClassStyle();
        hTMLTagWithClassStyle.setTag("div");
        hTMLTagWithClassStyle.setCssClass("CfgWizard");
        this.hdr = new ApcSectionHeader(this.theTitleText + this.thePageTitle, this.thePageDesc);
        this.hdr.setHelpId(this.getHelpId());
        hTMLTagWithClassStyle.add(this.hdr);
        ApcForm apcForm = new ApcForm("CFGWIZARD", this.action);
        apcForm.setId("CfgWizardForm");
        apcForm.setName(this.getPageName());
        this.thePage.addOnLoad("initValidation()");
        HTMLTagWithClassStyle hTMLTagWithClassStyle2 = new HTMLTagWithClassStyle();
        hTMLTagWithClassStyle2.setTag("div");
        hTMLTagWithClassStyle2.setCssClass("CfgWizardBody");
        this.setupForm(hTMLTagWithClassStyle2, pageContext);
        apcForm.add(hTMLTagWithClassStyle2);
        HTMLTagWithClassStyle hTMLTagWithClassStyle3 = new HTMLTagWithClassStyle();
        hTMLTagWithClassStyle3.setTag("div");
        hTMLTagWithClassStyle3.setId("footerdiv");
        hTMLTagWithClassStyle3.setCssClass("CfgWizardFooter");
        if (this.nextBtn != null) {
            this.nextBtn.setValue(this.theNextText);
            this.nextBtn.addClass("wizardButton");
            hTMLTagWithClassStyle3.add(this.nextBtn);
        }
        if (this.prevBtn != null) {
            this.prevBtn.setValue(this.thePreviousText);
            this.prevBtn.addClass("wizardButton");
            hTMLTagWithClassStyle3.add(this.prevBtn);
        }
        if (this.cancelBtn != null) {
            this.cancelBtn.setValue(this.theCancelText);
            this.cancelBtn.addClass("wizardButton");
            hTMLTagWithClassStyle3.add(this.cancelBtn);
            if (!this.configComplete) {
                this.cancelBtn.setDisable(true);
            }
        }
        apcForm.add(hTMLTagWithClassStyle3);
        pageContext.addFormToken(apcForm);
        hTMLTagWithClassStyle.add(apcForm);
        this.thePage.add(hTMLTagWithClassStyle);
        StringBuilder stringBuilder = new StringBuilder();
        HTMLDebug.htmlComment(stringBuilder, "Begin:" + this.getClass().getName());
        stringBuilder.append((CharSequence)this.thePage.toHTML(pageContext));
        HTMLDebug.htmlComment(stringBuilder, "Begin:" + this.getClass().getName());
        stringBuilder.trimToSize();
        return stringBuilder;
    }

    protected Integer getHelpId() {
        return ApcHelp.NO_HELP;
    }

    protected abstract String getI11nPrefix();

    protected String getPageName() {
        return this.getClass().getName();
    }

    protected abstract void setupForm(Container var1, PageContext var2);

    protected void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theProductText = Utils.getResourceString(resourceBundleWrapper, kProductId);
        this.theTitleText = Utils.getResourceString(resourceBundleWrapper, kTitleId);
        this.thePreviousText = Utils.getResourceString(resourceBundleWrapper, kPreviousId);
        this.theNextText = Utils.getResourceString(resourceBundleWrapper, kNextId);
        this.theCancelText = Utils.getResourceString(resourceBundleWrapper, kCancelId);
        this.thePageTitle = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kPageTitle);
        this.thePageDesc = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kPageDesc);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
    }

    protected Division createWaitDialog() {
        Division division = new Division();
        division.setCssClass("waitDialog");
        division.setId("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        return division;
    }

    protected void setHelpId(Integer n) {
        this.hdr.setHelpId(n);
    }

    @Generated
    public void setAction(String string) {
        this.action = string;
    }
}

