/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard;

import com.apcc.m11.components.omaha.LogUtils;
import com.apcc.m11.components.webserver.cfgwizard.Setting;
import com.apcc.m11.components.webserver.cfgwizard.pages.LoginPage;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.CfgWizardHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixDetails;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.userinterface.HyperconvergedSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import lombok.NonNull;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionManager {
    public static final String ATTR_ADVANCED_SETTINGS = "advSettings";
    public static final String ATTR_IP_ADDRESSES = "ipAddresses";
    public static final String ATTR_RESET = "reset";
    public static final String UNDO_CLICKED = "undo";
    public static final String VMWARE_DETAILS = "vmware_details";
    public static final String VCENTER_DETAILS = "vcenter_server_details";
    public static final String NUTANIX_DETAILS = "nutanix_details";
    public static final String SIMPLIVITY_DETAILS = "simplivity_details";
    public static final String HYPERFLEX_DETAILS = "hyperflex_details";
    public static final String VXRAIL_DETAILS = "vxrail_details";
    public static final String ESXI_HOST_DETAILS = "esxi_host_details";
    public static final String MAPPED_OUTLET_GROUPS = "mappedOutletGroups";
    public static final String ESXI_CONFIGURATION_MODE = "ESXIConfiguration";
    public static final String SCVMM_MANAGED = "scvmmManaged";
    public static final String HAS_SOG = "hasSOG";
    private final Logger logger = LogManager.getLogger(SessionManager.class);
    private ServiceManager services;
    private VMWareConnection vmwareConnection;

    public SessionManager(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
    }

    public void loadSettings(PageContext pageContext) {
        this.logger.debug("loadSettings() - start");
        for (Setting setting : Setting.values()) {
            this.logger.debug("loadSettings() - removing attribute: {}", (Object)setting.toString());
            pageContext.getSession().removeAttribute(setting.toString());
        }
        for (Setting setting : Setting.values()) {
            this.logger.debug("loadSettings() - setting attribute: {}", (Object)setting.toString());
            this.setAttrib(pageContext, setting);
        }
        this.loadIPAddresses(pageContext);
        this.loadAdvancedShutdownSettings(pageContext);
        this.loadGlobalVMSettings(pageContext);
        this.loadVMWareSettings(pageContext);
        this.logger.debug("loadSettings() - end");
    }

    private void loadIPAddresses(PageContext pageContext) {
        String[] stringArray = new String[]{};
        Vector<InetAddress> vector = Utils.getIPAddresses(pageContext);
        if (vector != null) {
            stringArray = new String[vector.size()];
            int n = 0;
            for (InetAddress inetAddress : vector) {
                stringArray[n] = inetAddress.getHostAddress();
                ++n;
            }
        }
        pageContext.getSession().setAttribute(ATTR_IP_ADDRESSES, (Object)stringArray);
    }

    private void loadAdvancedShutdownSettings(PageContext pageContext) {
        pageContext.getSession().setAttribute(ATTR_ADVANCED_SETTINGS, this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig());
    }

    private void loadVMWareSettings(PageContext pageContext) {
        VMWareDetails vMWareDetails = this.services.getVirtualConfigurationManager().loadServerDetails();
        if (this.services.getVirtualConfigurationManager().isManagedESXi()) {
            vMWareDetails.setUsername(this.services.getVirtualConfigurationManager().getVCenterUsername());
            vMWareDetails.setPassword(this.services.getVirtualConfigurationManager().getVCenterPassword());
            pageContext.getSession().setAttribute(VCENTER_DETAILS, (Object)vMWareDetails);
            pageContext.getSession().setAttribute(ESXI_CONFIGURATION_MODE, (Object)2);
        } else {
            vMWareDetails.setUsername(this.services.getAuthHelper().getEsxHostUser());
            vMWareDetails.setPassword(this.services.getAuthHelper().getEsxHostPassword());
            pageContext.getSession().setAttribute(ESXI_HOST_DETAILS, (Object)vMWareDetails);
            pageContext.getSession().setAttribute(ESXI_CONFIGURATION_MODE, (Object)1);
        }
        pageContext.getSession().setAttribute(VMWARE_DETAILS, (Object)vMWareDetails);
    }

    private void loadGlobalVMSettings(PageContext pageContext) {
        if (this.services.getVirtualConfigurationManager().isManagedESXiOrNutanixAHV()) {
            pageContext.getSession().setAttribute("VMSettings", (Object)this.services.getWebServerUtils().readVMSettingsFromConfigAndCluster());
        } else if (this.services.getVirtualConfigurationManager().isHyperV()) {
            pageContext.getSession().setAttribute("VMSettings", (Object)this.services.getWebServerUtils().readHypervVMSettingsFromConfig());
        }
    }

    private boolean applyIPAddresses(PageContext pageContext) {
        boolean bl = false;
        Object object = pageContext.getSession().getAttribute(ATTR_IP_ADDRESSES);
        if (object != null && object instanceof String[]) {
            String[] stringArray = (String[])object;
            Vector<InetAddress> vector = Utils.getIPAddresses(pageContext);
            if (vector == null && stringArray.length > 0) {
                bl = true;
            } else if (vector != null) {
                if (vector.size() != stringArray.length) {
                    bl = true;
                } else {
                    int n = 0;
                    for (InetAddress inetAddress : vector) {
                        if (!inetAddress.getHostAddress().equalsIgnoreCase(stringArray[n])) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
            }
            if (bl) {
                if (stringArray.length == 1) {
                    try {
                        bl |= pageContext.set(TCPIPCommunication.IpAddress.getObjectId(), InetAddress.getByName(stringArray[0]));
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.logger.error((Object)unknownHostException);
                    }
                } else {
                    Vector<InetAddress> vector2 = new Vector<InetAddress>(stringArray.length);
                    for (String string : stringArray) {
                        try {
                            vector2.add(InetAddress.getByName(string));
                        }
                        catch (UnknownHostException unknownHostException) {
                            this.logger.error((Object)unknownHostException);
                        }
                    }
                    bl |= pageContext.set(TCPIPCommunication.IpAddress.getObjectId(), vector2);
                }
            }
        }
        return bl;
    }

    private void applyAdvancedShutdownSettings(PageContext pageContext) {
        this.services.getAdvancedSetupHelper().removeAllAdvancedUPSSetups();
        if (Integer.valueOf(5).equals(CfgWizardHelper.getUPSConfiguration(pageContext))) {
            this.services.getAdvancedSetupHelper().saveUPSSetupsToConfig((List)pageContext.getSession().getAttribute(ATTR_ADVANCED_SETTINGS));
            if (this.services.getVirtualConfigurationManager().isESXi() || this.services.getVirtualConfigurationManager().isHyperV() || this.services.getVirtualConfigurationManager().isNutanixAHV()) {
                CfgWizardHelper.removeExecuteCommandFileAfterHostShutdownFromConfig();
            }
        } else if (this.services.getVirtualConfigurationManager().isManagedHost() || this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            CfgWizardHelper.addExecuteCommandFileAfterHostShutdownToConfig();
        }
    }

    private void applyVMWareSettings(PageContext pageContext) {
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            boolean bl = this.services.getVirtualConfigurationManager().isManagedHost();
            VMWareDetails vMWareDetails = (VMWareDetails)pageContext.getSession().getAttribute(VMWARE_DETAILS);
            this.services.getVirtualConfigurationManager().saveVMWareDetails(vMWareDetails, bl);
            this.services.getVirtualConfigurationManager().isPCNSInstalledOnVMA();
            if (bl) {
                this.vmwareConnection.logoutVCenterServer();
                boolean bl2 = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
                CfgWizardHelper.addVMPrioritizationKeysToConfig(bl2);
                CfgWizardHelper.addExitMaintenanceModeAndVCSAConnectionDelaystoConfig(this.services.getConfigurationManager());
            } else {
                this.services.getVirtualConfigurationManager().removeISVCSAKey();
                this.services.getVMPrioritizationUtils().removeVMPrioritizationKeysFromConfig();
                CfgWizardHelper.removeExitMaintenanceModeAndVCSAConnetionDelaysFromConfig();
            }
        }
    }

    public void applySimplivitySettings(PageContext pageContext) {
        if (this.services.getVirtualConfigurationManager().isSimplivity() || this.services.getVirtualConfigurationManager().getHyperconvergedSupportValueFromSession(pageContext.getSession()).equals((Object)HyperconvergedSupport.SIMPLIVITY)) {
            List list = (List)pageContext.getSession().getAttribute(SIMPLIVITY_DETAILS);
            this.services.getSimplivityUtils().saveSimplivityDetails(list);
        }
    }

    private void applyNutanixSettings(PageContext pageContext) {
        if (this.services.getVirtualConfigurationManager().isNutanixAHV() || this.services.getVirtualConfigurationManager().getHyperconvergedSupportValueFromSession(pageContext.getSession()).equals((Object)HyperconvergedSupport.NUTANIX)) {
            NutanixDetails nutanixDetails = (NutanixDetails)pageContext.getSession().getAttribute(NUTANIX_DETAILS);
            this.services.getNutanixUtils().saveNutanixDetails(nutanixDetails);
            boolean bl = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
            CfgWizardHelper.addVMPrioritizationKeysToConfig(bl);
        }
    }

    public void applyGlobalVMSettings(PageContext pageContext) {
        if (this.services.getVirtualConfigurationManager().isManagedHost() || this.services.getVirtualConfigurationManager().isHyperV() || this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            VMSettings vMSettings = null;
            Object object = pageContext.getSession().getAttribute("VMSettings");
            vMSettings = object == null || !(object instanceof VMSettings) ? new VMSettings() : (VMSettings)object;
            this.services.getWebServerUtils().saveVMSettingsToConfig(vMSettings, false);
        } else if (this.services.getVirtualConfigurationManager().isUnmanagedHost()) {
            CfgWizardHelper.removeGlobalVMSettingsFromConfig(this.services.getConfigurationManager());
        }
    }

    private void setAttrib(PageContext pageContext, Setting setting) {
        Object object = pageContext.get(setting.getObjectId());
        String string = setting.toString();
        if (object != null) {
            if (object instanceof InetAddress) {
                pageContext.getSession().setAttribute(string, (Object)((InetAddress)object).getHostAddress());
            } else if (object instanceof Vector) {
                if (setting == Setting.Port) {
                    Vector vector = (Vector)object;
                    pageContext.getSession().setAttribute(string, (Object)((Integer)vector.get(0)).toString());
                } else {
                    pageContext.getSession().setAttribute(string, object);
                }
            } else if (object instanceof Integer) {
                pageContext.getSession().setAttribute(string, (Object)((Integer)object).toString());
            } else {
                pageContext.getSession().setAttribute(string, object);
            }
        }
    }

    private void resetLog(PageContext pageContext) {
        pageContext.set(Communication.CommunicationConnectLog.getObjectId(), 1);
    }

    public void applySettings(PageContext pageContext) {
        this.logger.debug("applySettings() - start");
        boolean bl = false;
        try {
            bl |= this.applyIPAddresses(pageContext);
            this.resetLog(pageContext);
            this.applyIntAttrib(pageContext, Setting.ESXIConfiguration);
            this.applyVMWareSettings(pageContext);
            this.applyHyperVConfiguration(pageContext);
            this.applyNutanixSettings(pageContext);
            this.applyAdvancedShutdownSettings(pageContext);
            bl |= this.applyIpAttrib(pageContext, Setting.RegisterIp);
            bl |= this.applyIntAttrib(pageContext, Setting.UpsNetworkConfig);
            if (this.isIPv6NetworkConfiguration(pageContext)) {
                bl |= this.applyIntAttrib(pageContext, Setting.IPv6NetworkConfiguration);
                this.applyCastIpAttrib(pageContext, Setting.MulticastAddress);
                this.applyCastIpAttrib(pageContext, Setting.UnicastAddress);
            }
            bl |= this.applyIntAttrib(pageContext, Setting.Port);
            bl |= this.applyAuthPhrase(pageContext, Setting.AuthPhrase);
            bl |= this.applyAuthentication(pageContext, Setting.User, Setting.Pass);
            bl |= this.applyStringAttrib(pageContext, Setting.Protocol);
            this.applyCheckboxAttrib(pageContext, Setting.CheckUpdates);
            this.logger.debug("applySettings() - applied");
            if (bl |= this.applyUpsConfigAttrib(pageContext, Setting.UpsConfig)) {
                final PageContext pageContext2 = pageContext;
                final ServiceManager serviceManager = this.services;
                Thread thread = new Thread(new Runnable(){
                    private PageContext innerCtx;
                    private ServiceManager innerServices;
                    {
                        this.innerCtx = pageContext2;
                        this.innerServices = serviceManager;
                    }

                    @Override
                    public void run() {
                        SessionManager.this.logger.debug("applySettings() - registering");
                        this.innerServices.getApplicationErrorHandler().suspend(true);
                        this.innerCtx.set(Communication.CommunicationConnect.getObjectId(), 1);
                        this.innerServices.getApplicationErrorHandler().suspend(false);
                    }
                });
                thread.start();
            } else {
                this.logger.debug("applySettings() - nothing changed");
            }
        }
        catch (Exception exception) {
            this.logger.error("applySettings() - Exception: ", (Throwable)exception);
        }
        this.services.getWebServerUtils().cleanExtraUPSFromConfig(pageContext.getSession().getAttribute(ATTR_IP_ADDRESSES));
        this.loadSettings(pageContext);
        pageContext.getSession().setAttribute(Setting.AuthPhrase.toString(), (Object)LoginPage.theHiddenPhrase);
        this.logger.debug("applySettings() - end");
    }

    private boolean applyAuthentication(PageContext pageContext, Setting setting, Setting setting2) {
        String string;
        this.logger.debug("applyAuthentication() - start, user: {}", (Object)setting.name());
        boolean bl = false;
        String string2 = Utils.getRemoteAddress(pageContext);
        Object object = pageContext.get(setting.getObjectId());
        Object object2 = pageContext.getSession().getAttribute(setting.toString());
        String string3 = object2 != null ? object2.toString() : (string = object != null ? object.toString() : "");
        if (object2 != null && !object2.equals(object) && (bl = pageContext.set(setting.getObjectId(), object2.toString())) && object != null && !object.toString().trim().isEmpty()) {
            LogUtils.logMessage("UserNameChanged", object.toString(), string2, object2.toString());
        }
        object = pageContext.get(setting2.getObjectId());
        object2 = pageContext.getSession().getAttribute(setting2.toString());
        if (object2 != null && !object2.equals(object) && pageContext.set(setting2.getObjectId(), object2.toString())) {
            bl = true;
            if (object != null && !object.toString().trim().isEmpty()) {
                LogUtils.logMessage("PasswordChanged", string, string2);
            }
        }
        this.logger.debug("applyAuthentication() - end, user: {}", (Object)setting.name());
        return bl;
    }

    private boolean applyStringAttrib(PageContext pageContext, Setting setting) {
        this.logger.debug("applyStringAttrib() - start, setting: {}", (Object)setting.name());
        boolean bl = false;
        Object object = pageContext.get(setting.getObjectId());
        Object object2 = pageContext.getSession().getAttribute(setting.toString());
        if (object2 != null) {
            if (!object2.equals(object)) {
                bl |= pageContext.set(setting.getObjectId(), object2.toString());
            }
            this.logger.debug("applyStringAttrib() - end, setting: {}", (Object)setting.name());
        }
        return bl;
    }

    private boolean applyAuthPhrase(PageContext pageContext, Setting setting) {
        this.logger.debug("applyAuthPhrase() - start, setting: {}", (Object)setting.name());
        boolean bl = false;
        Object object = pageContext.get(setting.getObjectId());
        Object object2 = pageContext.getSession().getAttribute(setting.toString());
        if (object2 != null) {
            String string;
            String string2 = object2.toString().trim();
            String string3 = string = object != null ? object.toString().trim() : null;
            if (string2.equals(LoginPage.theHiddenPhrase)) {
                this.logger.trace("applyStringAttrib() -no new Auth Phrase");
            } else if (!string2.equals(string) && (bl |= pageContext.set(setting.getObjectId(), object2.toString())) && string != null && !string.isEmpty()) {
                String string4 = "";
                Object object3 = pageContext.getSession().getAttribute(Setting.User.toString());
                if (object3 != null) {
                    string4 = object3.toString();
                }
                LogUtils.logMessage("AuthPhraseChanged", string4, Utils.getRemoteAddress(pageContext));
            }
            this.logger.debug("applyStringAttrib() - setting: {}", (Object)setting.name());
        }
        return bl;
    }

    private boolean applyIntAttrib(PageContext pageContext, Setting setting) {
        this.logger.debug("applyIntAttrib() - start, setting: {}", (Object)setting.name());
        boolean bl = false;
        Object object = pageContext.get(setting.getObjectId());
        Object object2 = pageContext.getSession().getAttribute(setting.toString());
        if (object2 == null) {
            return false;
        }
        Integer n = null;
        if (object2 instanceof String && NumberUtils.isCreatable((String)((String)object2))) {
            n = NumberUtils.toInt((String)((String)object2));
        }
        if (object2 instanceof Integer) {
            n = (Integer)object2;
        }
        if (n != null) {
            if (!n.equals(object)) {
                bl |= pageContext.set(setting.getObjectId(), n);
            }
            this.logger.debug("applyIntAttrib() - setting: {}", (Object)setting.name());
        } else {
            this.logger.warn("Could not convert setting {} to integer", (Object)setting.name());
        }
        return bl;
    }

    private boolean applyCheckboxAttrib(PageContext pageContext, Setting setting) {
        this.logger.debug("applyCheckboxAttrib() - start, setting: {}", (Object)setting.name());
        boolean bl = false;
        Boolean bl2 = (Boolean)pageContext.get(setting.getObjectId());
        Object object = pageContext.getSession().getAttribute(setting.toString());
        Boolean bl3 = Boolean.FALSE;
        if (object instanceof String) {
            bl3 = ((String)object).equals("on");
        } else if (object instanceof Boolean) {
            bl3 = (Boolean)object;
        }
        if (!bl3.equals(bl2)) {
            bl |= pageContext.set(setting.getObjectId(), bl3);
        }
        this.logger.debug("applyIntAttrib() - end, setting: {}", (Object)setting.name());
        return bl;
    }

    private boolean applyUpsConfigAttrib(PageContext pageContext, Setting setting) {
        this.logger.debug("applyUpsConfigAttrib() - start, setting: {}", (Object)setting.name());
        boolean bl = false;
        Object object = pageContext.getSession().getAttribute(setting.toString());
        if (object != null) {
            Integer n = Integer.valueOf((String)object);
            bl |= pageContext.set(setting.getObjectId(), n);
            this.logger.debug("<applyUpsConfigAttrib() - setting: {}", (Object)setting.name());
        }
        return bl;
    }

    private boolean applyIpAttrib(PageContext pageContext, Setting setting) {
        this.logger.debug("applyIpAttrib() - start, setting: {}", (Object)setting.name());
        boolean bl = false;
        Object object = pageContext.get(setting.getObjectId());
        Object object2 = pageContext.getSession().getAttribute(setting.toString());
        if (object2 instanceof String[]) {
            Vector<InetAddress> vector = new Vector<InetAddress>();
            Vector vector2 = null;
            if (object instanceof Vector) {
                vector2 = (Vector)object;
            }
            String[] stringArray = (String[])object2;
            if (vector2 == null) {
                bl = true;
            } else if (vector2.size() != stringArray.length) {
                bl = true;
            } else {
                for (int i = 0; i < vector2.size(); ++i) {
                    bl |= ((InetAddress)vector2.get(i)).getHostAddress().equals(stringArray[i]);
                }
            }
            for (String string : stringArray) {
                if (string.equals("")) continue;
                try {
                    vector.add(InetAddress.getByName(string));
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.error((Object)unknownHostException);
                }
            }
            bl |= pageContext.set(setting.getObjectId(), vector);
        } else if (object2 instanceof String) {
            String string = (String)object2;
            if (object == null || object instanceof InetAddress) {
                try {
                    bl = pageContext.set(setting.getObjectId(), InetAddress.getByName(string));
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.error((Object)unknownHostException);
                }
            } else if (object != null && object instanceof Vector) {
                try {
                    bl = pageContext.set(setting.getObjectId(), InetAddress.getByName(string));
                }
                catch (UnknownHostException unknownHostException) {
                    this.logger.error((Object)unknownHostException);
                }
            }
        }
        this.logger.debug("applyIpAttrib() - end, setting: {}", (Object)setting.name());
        return bl;
    }

    private boolean applyCastIpAttrib(PageContext pageContext, Setting setting) {
        this.logger.debug("applyCastIpAttrib() - start, setting: {}", (Object)setting.name());
        boolean bl = false;
        Object object = pageContext.get(setting.getObjectId());
        Object object2 = pageContext.getSession().getAttribute(setting.toString());
        if (object2 instanceof String) {
            String string = (String)object2;
            try {
                if (object == null || object instanceof InetAddress || object instanceof String) {
                    bl = pageContext.set(setting.getObjectId(), InetAddress.getByName(string));
                } else if (object instanceof Vector) {
                    bl = pageContext.set(setting.getObjectId(), InetAddress.getByName(string));
                } else {
                    this.logger.warn("applyMulticastIpAttrib() - Format for {} is not recognised.", (Object)setting.getObjectId());
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.logger.error((Object)unknownHostException);
            }
        }
        return bl;
    }

    private boolean isIPv6NetworkConfiguration(PageContext pageContext) {
        String string = null;
        Object object = pageContext.getSession().getAttribute(Setting.UpsNetworkConfig.toString());
        if (object != null) {
            string = object.toString();
        }
        return string != null && string.equals(Integer.toString(2));
    }

    private void applyHyperVConfiguration(PageContext pageContext) {
        this.logger.debug("applyHyperVConfiguration() - start");
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            this.logger.debug("applyHyperVConfiguration() - isHyperV");
            if (pageContext.getSession().getAttribute("isManagedHost") != null) {
                this.logger.debug("applyHyperVConfiguration() - isManaged");
                boolean bl = (Boolean)pageContext.getSession().getAttribute("isManagedHost");
                String string = (String)pageContext.getSession().getAttribute("SCVMMIpName");
                this.services.getVirtualConfigurationManager().setManagedHost(bl);
                if (bl) {
                    this.services.getVirtualConfigurationManager().setServerIP(string);
                } else {
                    boolean bl2 = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
                    CfgWizardHelper.addVMPrioritizationKeysToConfig(bl2);
                    this.services.getVirtualConfigurationManager().removeServerIP();
                }
            }
        }
    }
}

