/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Checkbox;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CEIPPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(CEIPPage.class);
    private static final String kCEIPMsg = ".CEIPMessage";
    private static final String kEnableCEIPLabel = ".EnableCEIPLabel";
    private String theCEIPMsg;
    private String theEnableCEIPLabel;

    public CEIPPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getPageName() {
        return "CEIP";
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.CEIPPage";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.CEIP;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        logger.debug("setupForm() - start");
        Division division = new Division();
        division.setId("CEIP");
        Division division2 = new Division();
        division2.add(new Text(this.theCEIPMsg));
        division.add(division2);
        Division division3 = new Division();
        division3.add(new Text(this.theEnableCEIPLabel));
        division.add(division3);
        Checkbox checkbox = new Checkbox();
        checkbox.setId("CEIPEnabled");
        checkbox.setCheck(!Boolean.FALSE.equals(this.services.getAnalyticsService().isCEIPEnabled()));
        checkbox.setName("CEIPEnabled");
        division.add(checkbox);
        container.add(division);
        this.prevBtn.setDisable(true);
        logger.debug("setupForm() - end");
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theCEIPMsg = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kCEIPMsg);
        this.theEnableCEIPLabel = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kEnableCEIPLabel);
    }
}

