/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.stdpowersource.CommunicationsStatusLogEntry;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcSectionLabel;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableData;
import com.apcc.m11.components.webserver.html.table.TableHeader;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.pcns.util.DateTimeFormatUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionLog
implements HTML {
    private static final Logger logger = LogManager.getLogger(ConnectionLog.class);
    private static final String kTime = ".Time";
    private static final String kDescription = ".Description";
    private static final String kIPAddress = ".IPAddress";
    private String theTimeText;
    private String theDescriptionText;
    private String theIPAddressText;
    private ResourceBundleWrapper bundle = null;
    private DateTimeFormatUtils dateUtils;

    public ConnectionLog(@NonNull DateTimeFormatUtils dateTimeFormatUtils) {
        if (dateTimeFormatUtils == null) {
            throw new IllegalArgumentException("dateUtils is marked non-null but is null");
        }
        this.dateUtils = dateTimeFormatUtils;
    }

    private String getI11nPrefix() {
        return "CfgWizard.ConnectionLog";
    }

    @Override
    public StringBuilder toHTML(PageContext pageContext) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Vector vector;
        this.setupLanguage(pageContext.getLocale());
        Division division = new Division();
        Object object5 = pageContext.get(Communication.CommunicationConnectLogStatus.getObjectId());
        Integer n = null;
        if (object5 instanceof Integer) {
            n = (Integer)object5;
        } else if (object5 instanceof Map) {
            vector = (Map)object5;
            n = (Integer)vector.get("combo");
        }
        if (n == null) {
            n = 0;
        }
        object5 = pageContext.get(Communication.CommunicationConnectLog.getObjectId());
        vector = null;
        if (object5 instanceof Vector && !((Vector)object5).isEmpty()) {
            object4 = ((Vector)object5).firstElement();
            if (object4 instanceof Vector) {
                object3 = (Vector)object5;
                vector = new Vector();
                object2 = ((Vector)object3).iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    vector.addAll((Vector)object);
                }
            } else if (object4 instanceof CommunicationsStatusLogEntry) {
                vector = (Vector)object5;
            }
        }
        if (vector == null) {
            vector = new Vector();
        }
        Collections.sort(vector);
        object4 = new Table();
        object3 = new TableRow();
        object2 = new TableHeader(new ApcSectionLabel(this.theTimeText));
        object = new TableHeader(new ApcSectionLabel(this.theIPAddressText));
        TableHeader tableHeader = new TableHeader(new ApcSectionLabel(this.theDescriptionText));
        ((HTMLTagWithClassStyle)object2).setCssClass("LogTable_Table");
        ((HTMLTagWithClassStyle)object).setCssClass("LogTable_Table");
        tableHeader.setCssClass("LogTable_Desc");
        ((Container)object3).add((HTML)object2);
        ((Container)object3).add((HTML)object);
        ((Container)object3).add(tableHeader);
        ((HTMLTagWithClassStyle)object3).setCssClass("LogTable_Table");
        ((Container)object4).add((HTML)object3);
        ((HTMLTagWithClassStyle)object4).setCssClass("Log_Table");
        String[] stringArray = new String[]{"odd", "even"};
        int n2 = 0;
        for (CommunicationsStatusLogEntry communicationsStatusLogEntry : vector) {
            TableRow tableRow = new TableRow();
            TableData tableData = new TableData();
            TableData tableData2 = new TableData();
            TableData tableData3 = new TableData();
            tableData.setCssClass("LogTable_Table");
            tableData2.setCssClass("LogTable_Table");
            tableData3.setCssClass("LogTable_Desc");
            String string = stringArray[n2++];
            if (n2 > 1) {
                n2 = 0;
            }
            tableRow.setCssClass("StatusLogRow " + string);
            tableData.add(new Span(this.dateUtils.formatTableTime(communicationsStatusLogEntry.getTimestamp())));
            Span span = new Span();
            span.setCssClass("StatusLogIp");
            if (communicationsStatusLogEntry.getIp() != null) {
                span.setText(communicationsStatusLogEntry.getIp().getHostAddress());
            } else {
                span.setText("");
            }
            tableData2.add(span);
            Span span2 = new Span(communicationsStatusLogEntry.getLogMsg(this.bundle));
            span2.setCssClass("StatusLogMsg");
            tableData3.add(span2);
            tableRow.add(tableData);
            tableRow.add(tableData2);
            tableRow.add(tableData3);
            ((Container)object4).add(tableRow);
        }
        division.add((HTML)object4);
        return division.toHTML(pageContext);
    }

    public void setupLanguage(Locale locale) {
        this.bundle = Utils.getWebServerResourceBundle(locale);
        this.theTimeText = Utils.getResourceString(this.bundle, this.getI11nPrefix() + kTime);
        this.theDescriptionText = Utils.getResourceString(this.bundle, this.getI11nPrefix() + kDescription);
        this.theIPAddressText = Utils.getResourceString(this.bundle, this.getI11nPrefix() + kIPAddress);
    }
}

