/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.util.HostNMCMappingHelper;
import com.apcc.m11.components.webserver.util.HostSelectionHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostNMCMappingPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(HostNMCMappingPage.class);
    private HostNMCMappingHelper pageHelper = null;

    public HostNMCMappingPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.HostNMCMappingPage";
    }

    @Override
    protected String getPageName() {
        return "HostNMCMappingPage";
    }

    @Override
    protected Integer getHelpId() {
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            return ApcHelp.VMWARE_HOST_PROTECTION;
        }
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            return ApcHelp.SCVMM_HOST_PROTECTION;
        }
        if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            return ApcHelp.HOST_PROTECTION_AHV;
        }
        return ApcHelp.INTRODUCTION1;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        this.thePage.addStyleSheet("jstree/themes/default/style.min.css");
        this.thePage.addStyleSheet("styles/hostmap.css");
        this.thePage.addScript("jstree/jstree.min.js");
        this.thePage.addScript("scripts/inventory.js");
        this.thePage.addScript("scripts/hostnmc.js");
        this.initFormData(pageContext);
        this.prevBtn.setDisable(true);
        this.nextBtn.setDisable(true);
        this.cancelBtn.setDisable(true);
        Division division = new Division();
        division.setId("hostListsContainer");
        HostSelectionHTMLHelper hostSelectionHTMLHelper = new HostSelectionHTMLHelper(pageContext.getLocale(), false, false, this.services);
        hostSelectionHTMLHelper.createConnectionWaitHTML(division);
        container.add(division);
        this.thePage.add(this.createWaitDialog());
    }

    protected void initFormData(PageContext pageContext) {
        if (pageContext.getSession().getAttribute("mappedHosts") == null) {
            pageContext.getSession().setAttribute("mappedHosts", this.services.getAdvancedSetupHelper().readMappedHostsFromConfig());
        }
        List list = (List)pageContext.getSession().getAttribute("advSettings");
        this.pageHelper = new HostNMCMappingHelper(list, Utils.getNMCList(pageContext, true, true), (Map)pageContext.getSession().getAttribute("mappedHosts"), this.services);
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
    }
}

