/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.HyperVHTMLHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HyperVServerDetailsPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(HyperVServerDetailsPage.class);
    private static final String SCVMM_IP = "scvmm_ip";
    private String kYesId = "PCNS.YesButton";
    private String kNoId = "PCNS.NoButton";
    private String theYesText;
    private String theNoText;

    public HyperVServerDetailsPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.HyperVServerDetails";
    }

    @Override
    protected String getPageName() {
        return "Hyper-V Configuration";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.HYPER_V_CONFIGURATION;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        Object object;
        boolean bl;
        this.thePage.addStyleSheet("styles/form.css");
        this.thePage.addStyleSheet("styles/hostdetails.css");
        this.thePage.addScript("scripts/jquery.validate.min.js");
        this.thePage.addScript("scripts/hypervconfig.js");
        boolean bl2 = bl = this.services.getVirtualConfigurationManager().isHyperV() && this.services.getVirtualConfigurationManager().isManagedHost();
        if (bl && (object = this.services.getVirtualConfigurationManager().getServerIP()) != null) {
            pageContext.getSession().setAttribute(SCVMM_IP, object);
        }
        object = new HyperVHTMLHelper(pageContext.getLocale(), this.services);
        Division division = (Division)((HyperVHTMLHelper)object).createSCVMMHTML(pageContext, true);
        boolean bl3 = this.services.getVirtualConfigurationManager().isManagedHost();
        if (pageContext.getSession().getAttribute("isManagedHost") != null) {
            bl3 = (Boolean)pageContext.getSession().getAttribute("isManagedHost");
        }
        if (!bl3) {
            division.setCssClass("hidden");
        }
        Division division2 = new Division();
        division2.setId("wrapper");
        division2.add(FormHelper.createLabelRadioButtonValueDiv("theYesLabel", this.theYesText, "yes", bl3, "theYes", "scvmmManaged"));
        division2.add(division);
        division2.add(FormHelper.createLabelRadioButtonValueDiv("theNoLabel", this.theNoText, "no", !bl3, "theNo", "scvmmManaged"));
        container.add(division2);
        this.thePage.add(this.createWaitDialog());
        this.nextBtn.setDisable(true);
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theYesText = Utils.getResourceString(resourceBundleWrapper, this.kYesId);
        this.theNoText = Utils.getResourceString(resourceBundleWrapper, this.kNoId);
    }
}

