/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.util.NutanixHTMLHelper;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixUtils;
import com.apcc.pcns.ServiceManager;
import java.util.Locale;

public class NutanixConnectionPage
extends CfgWizardPage {
    public NutanixConnectionPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.NutanixClusterDetails";
    }

    @Override
    protected String getPageName() {
        return "Nutanix Connection Page";
    }

    @Override
    protected Integer getHelpId() {
        return this.services.getVirtualConfigurationManager().isNutanixAHV() ? ApcHelp.CVM_CLUSTER_DETAILS_AHV : ApcHelp.CVM_CLUSTER_DETAILS_ESXI;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        this.thePage.addStyleSheet("styles/form.css");
        this.thePage.addStyleSheet("styles/hostdetails.css");
        this.thePage.addScript("scripts/jquery.validate.min.js");
        this.thePage.addScript("scripts/nutanixconfig.js");
        NutanixHTMLHelper nutanixHTMLHelper = new NutanixHTMLHelper(pageContext.getLocale(), this.services);
        container.add(nutanixHTMLHelper.createNutanixConnectionHTML(pageContext, true));
        new NutanixUtils().addDefaultNutanixUsernamesToConfig();
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
    }
}

