/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.SessionManager;
import com.apcc.m11.components.webserver.cfgwizard.Setting;
import com.apcc.m11.components.webserver.cfgwizard.pages.LoginPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.NoScript;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class P01WelcomePage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(P01WelcomePage.class);
    private static final String kFirstMsg = ".FirstTimeMessage";
    private static final String kMsg = ".Message";
    private static final String kNoJsId = "Login.NoJavaScript";
    private static final String kNoCookiesId = "Login.NoCookies";
    private String theFirstMsg;
    private String theMsg;
    private String theNoJsText;
    private String theNoCookiesText;
    private boolean isInit;

    public P01WelcomePage(boolean bl, ServiceManager serviceManager) {
        super(serviceManager);
        this.isInit = bl;
    }

    @Override
    protected String getPageName() {
        return "Welcome";
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.P01WelcomePage";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.INTRODUCTION1;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        Division division = new Division();
        division.setId("Welcome_Msg");
        if (this.isInit) {
            division.add(new Text(this.theMsg));
        } else {
            division.add(new Text(this.theFirstMsg));
        }
        NoScript noScript = new NoScript();
        HTMLTagWithClassStyle hTMLTagWithClassStyle = new HTMLTagWithClassStyle();
        hTMLTagWithClassStyle.setTag("div");
        hTMLTagWithClassStyle.setCssClass("noscript-message");
        hTMLTagWithClassStyle.add(new Text(this.theNoJsText));
        noScript.add(hTMLTagWithClassStyle);
        division.add(noScript);
        HTMLTagWithClassStyle hTMLTagWithClassStyle2 = new HTMLTagWithClassStyle();
        hTMLTagWithClassStyle2.setTag("div");
        hTMLTagWithClassStyle2.setCssClass("noscript-message");
        hTMLTagWithClassStyle2.setId("noCookies");
        hTMLTagWithClassStyle2.setStyle("visibility: hidden;");
        hTMLTagWithClassStyle2.add(new Text(this.theNoCookiesText));
        division.add(hTMLTagWithClassStyle2);
        container.add(division);
        new SessionManager(this.services).loadSettings(pageContext);
        pageContext.getSession().setAttribute(Setting.Pass.toString(), (Object)"");
        Object object = pageContext.getSession().getAttribute(Setting.AuthPhrase.toString());
        if (object != null && !object.toString().isEmpty()) {
            pageContext.getSession().setAttribute(Setting.AuthPhrase.toString(), (Object)LoginPage.theHiddenPhrase);
        }
        this.prevBtn.setDisable(true);
        this.thePage.add(this.createWaitDialog());
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theFirstMsg = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kFirstMsg);
        this.theMsg = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kMsg);
        this.theNoJsText = Utils.getResourceString(resourceBundleWrapper, kNoJsId);
        this.theNoCookiesText = Utils.getResourceString(resourceBundleWrapper, kNoCookiesId);
    }
}

