/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.AJAXSUpsGroupConnectStatus;
import com.apcc.m11.components.webserver.cfgwizard.tasks.DisplayOutletsRunnable;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTMLdiv;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class P08ConnectPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(P08ConnectPage.class);
    private static final String kShowLogId = ".showLog";
    private static final String kHideLogId = ".hideLog";
    private static final String kNMCErrorId = ".NMCError";
    private String theShowLogText;
    private String theHideLogText;
    private String theErrorText;

    public P08ConnectPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getPageName() {
        return "P08ConnectPage";
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.P08ConnectPage";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.NETWORK_MANAGEMENT_CARD_TROUBLESHOOTING;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        this.thePage.addScript("scripts/ajaxupdater.js");
        this.thePage.addStyleSheet("styles/connectionlog.css");
        this.thePage.addOnLoad("AJAXInitConnectUps()");
        Span span = new Span(this.theErrorText);
        span.setCssClass("hidden");
        span.setId("resErrorMessage");
        container.add(span);
        HttpSession httpSession = pageContext.getSession();
        httpSession.removeAttribute(AJAXSUpsGroupConnectStatus.NMC_REGISTER_GROUPS);
        pageContext.set(Communication.CommunicationConnectLog.getObjectId(), 1);
        pageContext.getSession().setAttribute("applySettingsDone", (Object)Boolean.FALSE);
        DisplayOutletsRunnable displayOutletsRunnable = new DisplayOutletsRunnable(pageContext, this.services);
        this.services.getThreadService().submit(displayOutletsRunnable);
        container.add(new HTMLdiv("ApplyStatus"));
        Division division = this.createLogSection();
        container.add(division);
        this.thePage.add(this.createWaitDialog());
    }

    private Division createLogSection() {
        Division division = new Division();
        division.setId("logContainer");
        Division division2 = new Division();
        division2.setId("toogleLogDiv");
        Division division3 = new Division();
        Button button = new Button();
        button.setId("showLog");
        button.setValue(this.theShowLogText);
        division3.add(button);
        Division division4 = new Division();
        Button button2 = new Button();
        button2.setId("hideLog");
        button2.setValue(this.theHideLogText);
        division4.add(button2);
        division2.add(division3);
        division2.add(division4);
        division.add(division2);
        Division division5 = new Division();
        division5.setId("connectionLogDiv");
        division.add(division5);
        return division;
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theShowLogText = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kShowLogId);
        this.theHideLogText = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kHideLogId);
        this.theErrorText = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kNMCErrorId);
    }
}

