/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.AJAXSUpsGroupConnectStatus;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.html.form.Select;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class P09SOutletGroupSelectPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(P09SOutletGroupSelectPage.class);
    private static final String kMsg = ".Message";
    private static final String kOGLabel = ".OutletGroupLabel";
    private static final String kOGValidate = ".OutletGroupValidation";
    private static final String kNextButton = ".NextButton";
    private static final String OUTLET_ON = ".OutletOn";
    private static final String OUTLET_OFF = ".OutletOff";
    private static final String OUTLET_PENDING_OFF = ".OutletPendingOff";
    private static final String OUTLET_UNKNOWN = ".OutletUnknown";
    private String theOGValidate;
    private String theOGLabel;
    private String theMsg;
    private String outletOn;
    private String outletOff;
    private String outletPendingOff;
    private String outletUnknown;

    public P09SOutletGroupSelectPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getPageName() {
        return "SOGSelect";
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.P09SOGSelectPage";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.OUTLET_GROUP_REGISTRATION;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        Object object;
        Vector vector;
        pageContext.getSession().removeAttribute("fixPage");
        Division division = new Division(new Text(this.theMsg));
        division.setCssClass("UpsOGMessage");
        container.add(division);
        Object object2 = pageContext.get(TCPIPCommunication.IpAddress.getObjectId());
        Vector<InetAddress> vector2 = null;
        if (object2 instanceof Vector) {
            vector2 = (Vector<InetAddress>)object2;
        } else {
            vector2 = new Vector<InetAddress>();
            vector2.add((InetAddress)object2);
        }
        object2 = pageContext.get(TCPIPCommunication.OutletGroupList.getObjectId());
        Vector vector3 = new Vector();
        if (object2 instanceof Vector && !(vector = (Vector)object2).isEmpty()) {
            object = vector.get(0);
            if (object instanceof Vector) {
                vector3 = (Vector)object2;
            } else if (object2 != null) {
                vector3.add((Vector)object2);
            }
        }
        int n = 1;
        if ("advanced".equals(this.services.getVirtualConfigurationManager().getUPSConfigMode())) {
            object = (Map)pageContext.getSession().getAttribute(AJAXSUpsGroupConnectStatus.NMC_REGISTER_GROUPS);
            if (object != null) {
                HTMLTagWithClassStyle hTMLTagWithClassStyle = new HTMLTagWithClassStyle();
                hTMLTagWithClassStyle.setTag("div");
                hTMLTagWithClassStyle.setId("UpsGroupsContainer");
                for (UPSSetup uPSSetup : object.values()) {
                    List<String> list = uPSSetup.getNMCList();
                    ArrayList<Division> arrayList = new ArrayList<Division>();
                    for (String string : list) {
                        Division division2 = this.createUPSOGSection(vector3, string, n);
                        if (division2 == null) continue;
                        arrayList.add(division2);
                        ++n;
                    }
                    if (arrayList.size() <= 0) continue;
                    String string = uPSSetup.getNameEsc();
                    HTMLTagWithClassStyle hTMLTagWithClassStyle2 = new HTMLTagWithClassStyle();
                    hTMLTagWithClassStyle2.setTag("div");
                    hTMLTagWithClassStyle2.add(new Text(string));
                    hTMLTagWithClassStyle2.setCssClass("UPSGroup ui-state-default ui-corner-all");
                    hTMLTagWithClassStyle.add(hTMLTagWithClassStyle2);
                    for (Division division3 : arrayList) {
                        hTMLTagWithClassStyle.add(division3);
                    }
                }
                container.add(hTMLTagWithClassStyle);
            }
        } else {
            for (InetAddress inetAddress : vector2) {
                Division division4 = this.createUPSOGSection(vector3, inetAddress.getHostAddress(), n);
                if (division4 == null) continue;
                container.add(division4);
                ++n;
            }
        }
        if (!this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV()) {
            this.prevBtn.setDisable(true);
        }
        this.cancelBtn.setDisable(true);
        this.thePage.add(this.createWaitDialog());
    }

    protected Division createUPSOGSection(Vector<Vector<OutletGroup>> vector, String string, int n) {
        Object object;
        boolean bl = false;
        Select select = new Select("UpsEntryOGs_combo_" + string);
        select.add(new Option(""));
        for (List object4 : vector) {
            for (Object object2 : object4) {
                if (!string.equals(((OutletGroup)object2).getIpAddress())) continue;
                object = ((OutletGroup)object2).getName();
                if (((String)object).isEmpty()) {
                    object = Integer.toString(((OutletGroup)object2).getGroupNumber());
                }
                object = (String)object + ": " + this.getOutletStateString(((OutletGroup)object2).getState());
                Option option = new Option(Integer.toString(((OutletGroup)object2).getGroupNumber()), (String)object);
                option.setSelected(((OutletGroup)object2).isSelected());
                select.add(option);
                bl = true;
            }
        }
        if (bl) {
            Object object2;
            Division division = new Division();
            division.setCssClass("UpsEntry_ok");
            division.setId("UpsEntry" + n);
            Division division2 = new Division(new Text(string));
            division2.setCssClass("UpsEntryIp");
            division2.setId("UpsEntryIp" + n);
            division.add(division2);
            Division division3 = new Division();
            division3.setCssClass("UpsEntryOGs");
            division3.setId("UpsEntryOGs" + n);
            object2 = new Division(new Text(this.theOGLabel));
            division3.add((HTML)object2);
            division3.add(select);
            object = new Division(new Text(this.theOGValidate));
            ((HTMLTagWithClassStyle)object).setCssClass("CfgWizardInputValidation");
            ((HTMLTagWithClassStyle)object).setId("UpsEntryOGs_validation" + n);
            division3.add((HTML)object);
            division.add(division3);
            return division;
        }
        return null;
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theMsg = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kMsg);
        this.theOGLabel = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kOGLabel);
        this.theOGValidate = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kOGValidate);
        this.outletOff = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + OUTLET_OFF);
        this.outletOn = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + OUTLET_ON);
        this.outletPendingOff = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + OUTLET_PENDING_OFF);
        this.outletUnknown = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + OUTLET_UNKNOWN);
        this.theNextText = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kNextButton);
    }

    private String getOutletStateString(Integer n) {
        String string = this.outletUnknown;
        if (n != null) {
            switch (n) {
                case 1: {
                    string = this.outletOn;
                    break;
                }
                case 0: {
                    string = this.outletOff;
                    break;
                }
                case 3: {
                    string = this.outletPendingOff;
                    break;
                }
                default: {
                    string = this.outletUnknown;
                }
            }
        }
        return string;
    }
}

