/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTMLdiv;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.Communication;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class P10SOutletGroupSetPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(P10SOutletGroupSetPage.class);
    private static final String kFinishButton = ".FinishButton";
    private static final String kRegisterWithMixedUPSEnvWarning = "HostNMCMapping.RegisterWithMixedUPSEnvWarning";
    private static final String kRegisterWithMultipleOGWarning = "HostNMCMapping.RegisterWithMultipleOGWarning";
    private static final String kRegisterWithNoHostMappedWarning = "HostNMCMapping.RegisterWithNoHostMappedWarning";
    private static final String kNMCErrorId = "CfgWizard.P08ConnectPage.NMCError";
    private String theRegisterWithMixedUPSEnvWarningText;
    private String theRegisterWithMultipleOGWarningText;
    private String theRegisterWithNoHostMappedWarningText;
    private String theErrorText;

    public P10SOutletGroupSetPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getPageName() {
        return "SOGSet";
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.P10SOGSetPage";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.OUTLET_GROUP_REGISTRATION;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        this.thePage.addScript("scripts/ajaxupdater.js");
        this.thePage.addOnLoad("AJAXInitSetOG()");
        Span span = new Span(this.theErrorText);
        span.setCssClass("hidden");
        span.setId("resErrorMessage");
        container.add(span);
        pageContext.set(Communication.CommunicationConnectLog.getObjectId(), 1);
        ArrayList arrayList = new ArrayList();
        if (this.services.getAdvancedSetupHelper().getSingleUPSSetupSetting()) {
            arrayList = (List)pageContext.getSession().getAttribute("mappedOutletGroups");
            this.displayRegistrationWarnings(container, pageContext);
        } else {
            arrayList = (ArrayList)pageContext.getSession().getAttribute("mappedOutletGroups");
        }
        ServiceManager.getInstance().getApplicationErrorHandler().suspend(true);
        for (OutletGroup outletGroup : arrayList) {
            pageContext.setNoWait(TCPIPCommunication.OutletGroup.getObjectId(), outletGroup);
        }
        ServiceManager.getInstance().getApplicationErrorHandler().suspend(false);
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            this.services.getAdvancedSetupHelper().updateUPSSetupsTurnOffOutletGroups(pageContext);
        }
        container.add(new HTMLdiv("ApplyStatus"));
        this.nextBtn.setDisable(true);
        this.prevBtn.setDisable(true);
        this.thePage.add(this.createWaitDialog());
    }

    private void displayRegistrationWarnings(Container container, PageContext pageContext) {
        Image image;
        Division division;
        Text text = null;
        Text text2 = null;
        if (Utils.hasOutletGroups(pageContext)) {
            if (this.services.getAdvancedSetupHelper().hasUPSSetupWithHostsMappedToMultipleOutletGroups()) {
                text = new Text(this.theRegisterWithMultipleOGWarningText);
            }
            if (this.services.getWebServerUtils().hasUPSWithNoHostsMapped(pageContext)) {
                text2 = new Text(this.theRegisterWithNoHostMappedWarningText);
            }
        }
        if (text != null) {
            division = new Division();
            division.setId("StatusLogWarning");
            image = new Image("/images/exclamation.gif");
            image.setCssClass("StatusLogWarningImg");
            division.add(image);
            division.add(text);
            division.setCssClass("StatusLogWarning ui-state-default ui-corner-all");
            container.add(division);
        }
        if (text2 != null) {
            division = new Division();
            division.setId("StatusLogWarning");
            image = new Image("/images/exclamation.gif");
            image.setCssClass("StatusLogWarningImg");
            division.add(image);
            division.add(text2);
            division.setCssClass("StatusLogWarning ui-state-default ui-corner-all");
            container.add(division);
        }
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theCancelText = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kFinishButton);
        this.theRegisterWithMixedUPSEnvWarningText = Utils.getResourceString(resourceBundleWrapper, kRegisterWithMixedUPSEnvWarning);
        this.theRegisterWithMultipleOGWarningText = Utils.getResourceString(resourceBundleWrapper, kRegisterWithMultipleOGWarning);
        this.theRegisterWithNoHostMappedWarningText = Utils.getResourceString(resourceBundleWrapper, kRegisterWithNoHostMappedWarning);
        this.theErrorText = Utils.getResourceString(resourceBundleWrapper, kNMCErrorId);
    }
}

