/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.Setting;
import com.apcc.m11.components.webserver.cfgwizard.html.WizardInputRadio;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSection;
import com.apcc.m11.components.webserver.html.apc.ApcSectionNote;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.IPUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class P11IpConfigurationPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(P11IpConfigurationPage.class);
    private static final String kNetworkConfigLabel = ".NetworkConfigLabel";
    private String theNetworkConfigLabel;
    private static final String kNetworkConfigNote = ".NetworkConfigNote";
    private String theNetworkConfigNote;
    private static final String kNetworkConfigValidation = ".NetworkConfigValidationNote";
    private String theNetworkConfigValidation;
    private static final String kNetworkConfigOption1 = ".NetworkConfigOption1";
    private String theNetworkConfigOption1;
    private static final String kNetworkConfigOption2 = ".NetworkConfigOption2";
    private String theNetworkConfigOption2;

    public P11IpConfigurationPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getPageName() {
        return "Select Network Configuration";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.NETWORK_CONFIGURATION;
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.P11IpConfigurationPage";
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        ApcSection apcSection = new ApcSection();
        ApcSectionNote apcSectionNote = new ApcSectionNote(this.theNetworkConfigLabel);
        apcSectionNote.setVisible(true);
        apcSectionNote.setStyle("border: 0;");
        apcSection.add(apcSectionNote, null);
        apcSection.addSpacer();
        WizardInputRadio wizardInputRadio = new WizardInputRadio(Setting.UpsNetworkConfig.toString(), "", this.theNetworkConfigValidation, this.theNetworkConfigNote);
        Set<InetAddress> set = IPUtils.getLocalhostIPv6Addresses();
        Set<InetAddress> set2 = IPUtils.getLocalhostAddresses();
        if (set2 != null && !set2.isEmpty()) {
            wizardInputRadio.addOption(1, this.theNetworkConfigOption1, "", "");
        }
        if (set != null && !set.isEmpty()) {
            wizardInputRadio.addOption(2, this.theNetworkConfigOption2, "", "");
        }
        apcSection.add(wizardInputRadio, null);
        container.add(apcSection);
        this.thePage.add(this.createWaitDialog());
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theNetworkConfigLabel = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kNetworkConfigLabel);
        this.theNetworkConfigNote = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kNetworkConfigNote);
        this.theNetworkConfigValidation = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kNetworkConfigValidation);
        this.theNetworkConfigOption1 = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kNetworkConfigOption1);
        this.theNetworkConfigOption2 = Utils.getResourceString(resourceBundleWrapper, this.getI11nPrefix() + kNetworkConfigOption2);
    }
}

