/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.util.HostSelectionHTMLHelper;
import com.apcc.pcns.ServiceManager;
import java.util.Locale;

public class TargetHostSelectionPage
extends CfgWizardPage {
    public TargetHostSelectionPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.TargetHostSelectionPage";
    }

    @Override
    protected String getPageName() {
        return "TargetHostSelectionPage";
    }

    @Override
    protected Integer getHelpId() {
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            return ApcHelp.VMWARE_HOST_PROTECTION;
        }
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            return ApcHelp.SCVMM_HOST_PROTECTION;
        }
        if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            return ApcHelp.HOST_PROTECTION_AHV;
        }
        return ApcHelp.INTRODUCTION1;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        this.thePage.addStyleSheet("jstree/themes/default/style.min.css");
        this.thePage.addStyleSheet("styles/hostmap.css");
        this.thePage.addScript("jstree/jstree.min.js");
        this.thePage.addScript("scripts/content.js");
        this.thePage.addScript("scripts/inventory.js");
        this.thePage.addScript("scripts/targethost.js");
        this.initFormData(pageContext);
        this.prevBtn.setDisable(true);
        this.nextBtn.setDisable(true);
        this.cancelBtn.setDisable(true);
        Division division = new Division();
        division.setId("hostListsContainer");
        HostSelectionHTMLHelper hostSelectionHTMLHelper = new HostSelectionHTMLHelper(pageContext.getLocale(), false, false, this.services);
        hostSelectionHTMLHelper.createConnectionWaitHTML(division);
        container.add(division);
        this.thePage.add(this.createWaitDialog());
    }

    protected void initFormData(PageContext pageContext) {
        if (pageContext.getSession().getAttribute("targetHosts") == null) {
            pageContext.getSession().setAttribute("targetHosts", this.services.getVirtualConfigurationManager().parseHostListParameter("HostConfigSettings"));
        }
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
    }
}

