/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.Setting;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithAlignClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Label;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.html.form.RadioButton;
import com.apcc.m11.components.webserver.html.form.TextInput;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.CfgWizardHelper;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UPSGroupsPage
extends CfgWizardPage {
    private static final Logger logger = LogManager.getLogger(UPSGroupsPage.class);
    private static final String kProtocolLabel = "CfgWizard.P05UpsDetailsPage.ProtocolLabel";
    private static final String kProtocolTooltip = "CfgWizard.P05UpsDetailsPage.ProtocolNote";
    private static final String kPortLabel = "CfgWizard.P05UpsDetailsPage.PortLabel";
    private static final String kInvalidPort = "CfgWizard.P05UpsDetailsPage.PortValidationNote";
    private static final String kUPSGroupsHeader = "AdvancedShutdown.UPSGroupsHeader";
    private static final String kAddGroupButton = "AdvancedShutdown.AddGroupButton";
    private static final String kUPSGroupDialogTitle = "AdvancedShutdown.UPSGroupDialogTitle";
    private static final String kNoUPSGroupConfigured = "AdvancedShutdown.NoUPSGroupConfigured";
    private static final String kSingleUPSRadioLabel = "AdvancedShutdown.SingleUPSRadioLabel";
    private static final String kUPSGroupRadioLabel = "AdvancedShutdown.UPSGroupRadioLabel";
    private static final String kUPSGroupNameLabel = "AdvancedShutdown.UPSGroupNameLabel";
    private static final String kUPSGroupNameInUse = "AdvancedShutdown.UPSGroupNameInUse";
    private static final String kUPSGroupNameUSASCII = "AdvancedShutdown.UPSGroupNameUSASCII";
    private static final String kIPDialogTitle = "AdvancedShutdown.IPDialogTitle";
    private static final String kInvalidIPAddress = "AdvancedShutdown.IpValidation";
    private static final String kNoIPConfigured = "AdvancedShutdown.NoIPConfigured";
    private static final String kMinIPRequired = "AdvancedShutdown.MinIPConfigured";
    private static final String kAddIPButton = "AdvancedShutdown.AddIPButton";
    private static final String kIPHeader = "AdvancedShutdown.IPHeader";
    private static final String kIPLabel = "AdvancedShutdown.IPLabel";
    private static final String kIPInUse = "AdvancedShutdown.IPInUse";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kOKButton = "PCNS.OKButton";
    private static final String kCancelButton = "PCNS.CancelButton";
    private static final String kCloseButton = "PCNS.CloseButton";
    private static final String kGroupDeleteTitle = "PCNS.GroupDeleteTitle";
    private static final String kGroupDelete = "PCNS.GroupDelete";
    private static final String kYesButton = "PCNS.YesButton";
    private static final String kNoButton = "PCNS.NoButton";
    private String theProtocolLabelText;
    private String theProtocolTooltipText;
    private String thePortLabelText;
    private String theInvalidPortText;
    private String theUPSGroupsHeaderText;
    private String theAddGroupButtonText;
    private String theNoUPSGroupConfiguredText;
    private String theUPSGroupDialogTitleText;
    private String theSingleUPSRadioLabelText;
    private String theUPSGroupRadioLabelText;
    private String theUPSGroupNameLabelText;
    private String theUPSGroupNameInUseText;
    private String theUPSGroupNameUSASCIIText;
    private String theIPDialogTitleText;
    private String theInvalidIPAddressText;
    private String theNoIPConfiguredText;
    private String theMinIPRequiredText;
    private String theAddIPButtonText;
    private String theIPHeaderText;
    private String theIPLabelText;
    private String theIPInUseText;
    private String theRequiredFieldText;
    private String theOKButtonText;
    private String theCancelButtonText;
    private String theCloseButtonText;
    private String theGroupDeleteTitleText;
    private String theGroupDeleteText;
    private String theYesButtonText;
    private String theNoButtonText;
    private List<UPSSetup> advSettings = null;
    private String[] ips = null;
    private Integer upsConfig = null;

    public UPSGroupsPage(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected String getI11nPrefix() {
        return "CfgWizard.UPSGroupsPage";
    }

    @Override
    protected String getPageName() {
        return "UPSGroupsPage";
    }

    @Override
    protected Integer getHelpId() {
        return ApcHelp.NETWORK_MANAGEMENT_CARD_CONNECTION;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        this.thePage.addStyleSheet("styles/form.css");
        this.thePage.addStyleSheet("styles/upsgroups.css");
        this.thePage.addScript("scripts/jquery.validate.min.js");
        this.thePage.addScript("scripts/upsgroups.js");
        this.initFormData(pageContext);
        this.setIPv6Flag(pageContext, container);
        container.add(this.createUPSConfigurationDiv());
        container.add(this.createConnectionHTML(pageContext));
        if (this.upsConfig.equals(5)) {
            container.add(this.createUPSGroupsHTML(pageContext));
        } else if (this.upsConfig.equals(2) || this.upsConfig.equals(3)) {
            container.add(this.createIPListHTML(pageContext));
            this.thePage.add(this.createUPSIPHTML());
        }
        container.add(this.createResourceStrings());
        if (this.upsConfig.equals(5)) {
            this.setHelpId(ApcHelp.UPS_CONFIGURATION_ADVANCED_CLUSTER_CONFIGURATION);
            this.thePage.add(this.createUPSGroupHTML());
            this.thePage.add(this.createUPSIPHTML());
            this.thePage.add(this.createGroupDeleteDialog());
        }
        this.thePage.add(this.createWaitDialog());
    }

    protected void initFormData(PageContext pageContext) {
        this.ips = new String[0];
        this.upsConfig = CfgWizardHelper.getUPSConfiguration(pageContext);
        Object object = pageContext.getSession().getAttribute("ipAddresses");
        if (object != null && object instanceof String[]) {
            this.ips = (String[])object;
        }
        if (Integer.valueOf(5).equals(this.upsConfig)) {
            this.advSettings = new ArrayList<UPSSetup>();
            Object object2 = pageContext.getSession().getAttribute("advSettings");
            if (object2 instanceof List) {
                this.advSettings = (List)object2;
            }
        }
    }

    private Division createGroupDeleteDialog() {
        Division division = new Division();
        division.setId("deleteGroupDialog");
        division.setTitle(this.theGroupDeleteTitleText);
        division.add(new Text(this.theGroupDeleteText));
        return division;
    }

    private boolean setIPv6Flag(PageContext pageContext, Container container) {
        boolean bl = false;
        String string = CfgWizardHelper.getNetworkConfiguration(pageContext.getSession());
        if (Integer.toString(2).equalsIgnoreCase(string)) {
            bl = true;
            Division division = new Division();
            division.setId("ipv6");
            division.setCssClass("hidden");
            container.add(division);
        }
        return bl;
    }

    private Division createUPSConfigurationDiv() {
        Division division = new Division();
        division.setId("mode");
        division.setCssClass("hidden");
        division.add(new Text(this.upsConfig.toString()));
        return division;
    }

    private HTML createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.theRequiredFieldText);
        span.setId("resRequiredField");
        division.add(span);
        span = new Span(this.theInvalidPortText);
        span.setId("resInvalidPort");
        division.add(span);
        span = new Span(this.theOKButtonText);
        span.setId("resOKButton");
        division.add(span);
        span = new Span(this.theCancelButtonText);
        span.setId("resCancelButton");
        division.add(span);
        span = new Span(this.theCloseButtonText);
        span.setId("resCloseButton");
        division.add(span);
        span = new Span(this.theUPSGroupDialogTitleText);
        span.setId("resUPSGroupDialogTitle");
        division.add(span);
        span = new Span(this.theUPSGroupNameInUseText);
        span.setId("resUPSGroupNameInUse");
        division.add(span);
        span = new Span(this.theUPSGroupNameUSASCIIText);
        span.setId("resUPSGroupNameUSASCII");
        division.add(span);
        span = new Span(this.theInvalidIPAddressText);
        span.setId("resInvalidIPAddress");
        division.add(span);
        span = new Span(this.theIPInUseText);
        span.setId("resIPInUse");
        division.add(span);
        span = new Span(this.theIPDialogTitleText);
        span.setId("resIPDialogTitle");
        division.add(span);
        span = new Span(this.theGroupDeleteText);
        span.setId("resDeleteGroup");
        division.add(span);
        span = new Span(this.theGroupDeleteTitleText);
        span.setId("resDeleteGroupTitle");
        division.add(span);
        span = new Span(this.theYesButtonText);
        span.setId("resYesButton");
        division.add(span);
        span = new Span(this.theNoButtonText);
        span.setId("resNoButton");
        division.add(span);
        return division;
    }

    private HTML createConnectionHTML(PageContext pageContext) {
        Division division = new Division();
        division.setId("connection");
        division.setCssClass("formdiv");
        String string = Setting.Protocol.toString();
        String string2 = (String)pageContext.getSession().getAttribute(string);
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("http"));
        vector.add(new Option("https"));
        division.add(FormHelper.createLabelSelectValueDiv(null, this.theProtocolLabelText, string2, string, string, vector, this.theProtocolTooltipText));
        String string3 = Setting.Port.toString();
        Object object = pageContext.getSession().getAttribute(string3);
        TextInput textInput = new TextInput();
        textInput.setAutoComplete(false);
        textInput.setValue(object != null ? object.toString() : "");
        textInput.setId(string3);
        textInput.setName(string3);
        textInput.setMaxLength("5");
        textInput.setSize("7");
        division.add(FormHelper.createLabelTextInputValueDiv(null, this.thePortLabelText, object != null ? object.toString() : "", string3, string3, null, 5, null, null));
        if (this.upsConfig.equals(1)) {
            String string4 = "";
            if (this.ips != null && this.ips.length > 0) {
                string4 = this.ips[0];
            }
            division.add(FormHelper.createLabelTextInputValueDiv(null, this.theIPLabelText, string4, null, "upsip", null, 64, null, null));
        }
        return division;
    }

    private HTML createUPSGroupsHTML(PageContext pageContext) {
        Division division = new Division();
        division.setId("upsGroups");
        division.setCssClass("ui-widget formdiv");
        Division division2 = new Division();
        division.add(division2);
        division2.setId("upsGroupsHeader");
        division2.setCssClass("ui-widget-header ui-corner-top");
        division2.add(new Text(this.theUPSGroupsHeaderText));
        Anchor anchor = new Anchor();
        division2.add(anchor);
        anchor.setId("addGroupBtn");
        anchor.setHypertextReference("#");
        anchor.add(new Text(this.theAddGroupButtonText));
        UnOrderedList unOrderedList = new UnOrderedList();
        division.add(unOrderedList);
        unOrderedList.setId("upsGroupsList");
        unOrderedList.setCssClass("ui-widget-content ui-corner-bottom");
        ListItem listItem = null;
        for (UPSSetup uPSSetup : this.advSettings) {
            listItem = new ListItem();
            unOrderedList.add(listItem);
            listItem.setCssClass("upsGroupItem ui-widget-content ui-corner-all");
            Span span = new Span(uPSSetup.getNameEsc());
            listItem.add(span);
            if (uPSSetup.getNMCList().size() > 1) {
                span.setCssClass("upsGroupName UPSSetupGroup");
            } else {
                span.setCssClass("upsGroupName UPSSetupSingle");
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : uPSSetup.getNMCList()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(string);
            }
            Span span2 = new Span(stringBuffer.toString());
            listItem.add(span2);
            span2.setCssClass("upsList");
            Anchor anchor2 = new Anchor();
            listItem.add(anchor2);
            anchor2.setHypertextReference("#");
            anchor2.setCssClass("editBtn");
            Anchor object2 = new Anchor();
            listItem.add(object2);
            object2.setHypertextReference("#");
            object2.setCssClass("deleteBtn");
        }
        Division division3 = new Division();
        division3.setId("nogroupsdiv");
        division3.add(new Text(this.theNoUPSGroupConfiguredText));
        division.add(division3);
        return division;
    }

    private HTML createIPListHTML(PageContext pageContext) {
        Division division = new Division();
        division.setId("upsGroups");
        division.setCssClass("ui-widget formdiv");
        division.add(this.createUPSList());
        return division;
    }

    private HTML createUPSGroupHTML() {
        Division division = new Division();
        division.setId("upsGroupDialog");
        Form form = new Form();
        division.add(form);
        form.setId("upsGroupForm");
        form.add(this.createUPSConfigRadioButtons());
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theUPSGroupNameLabelText, "", null, "upsGroupName", null, 20, null, null));
        form.add(this.createUPSList());
        Input input = new Input();
        form.add(input);
        input.setType("hidden");
        input.setId("upsGroupIndex");
        input.setName("upsGroupIndex");
        input.setValue("-1");
        return division;
    }

    private Division createUPSList() {
        HTMLTagWithAlignClassStyle hTMLTagWithAlignClassStyle;
        Division division = new Division();
        division.setId("upsListDiv");
        division.setCssClass("ui-widget");
        Division division2 = new Division();
        division.add(division2);
        division2.setId("upsListHeader");
        division2.setCssClass("ui-widget-header ui-corner-top");
        division2.add(new Text(this.theIPHeaderText));
        Anchor anchor = new Anchor();
        division2.add(anchor);
        anchor.setId("addUPSBtn");
        anchor.setHypertextReference("#");
        anchor.add(new Text(this.theAddIPButtonText));
        UnOrderedList unOrderedList = new UnOrderedList();
        division.add(unOrderedList);
        unOrderedList.setId("upsList");
        unOrderedList.setCssClass("ui-widget-content ui-corner-bottom");
        if (this.upsConfig.equals(2) || this.upsConfig.equals(3)) {
            hTMLTagWithAlignClassStyle = null;
            for (String string : this.ips) {
                hTMLTagWithAlignClassStyle = new ListItem();
                unOrderedList.add(hTMLTagWithAlignClassStyle);
                hTMLTagWithAlignClassStyle.setCssClass("upsItem ui-widget-content ui-corner-all");
                Span span = new Span(StringEscapeUtils.escapeHtml4((String)string));
                hTMLTagWithAlignClassStyle.add(span);
                span.setCssClass("upsIP");
                Anchor anchor2 = new Anchor();
                hTMLTagWithAlignClassStyle.add(anchor2);
                anchor2.setHypertextReference("#");
                anchor2.setCssClass("editBtn");
                anchor2 = new Anchor();
                hTMLTagWithAlignClassStyle.add(anchor2);
                anchor2.setHypertextReference("#");
                anchor2.setCssClass("deleteBtn");
            }
        }
        hTMLTagWithAlignClassStyle = new Division();
        hTMLTagWithAlignClassStyle.setId("noipdiv");
        hTMLTagWithAlignClassStyle.add(new Text(this.theNoIPConfiguredText));
        division.add(hTMLTagWithAlignClassStyle);
        Division division3 = new Division();
        division3.setId("minipdiv");
        division3.add(new Text(this.theMinIPRequiredText));
        division.add(division3);
        return division;
    }

    private HTML createUPSIPHTML() {
        Division division = new Division();
        division.setId("IPDialog");
        Form form = new Form();
        form.setId("IPForm");
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theIPLabelText, "", null, "upsip", null, 64, null, null));
        Input input = new Input();
        form.add(input);
        input.setType("hidden");
        input.setId("IPIndex");
        input.setName("IPIndex");
        input.setValue("-1");
        division.add(form);
        return division;
    }

    private HTML createUPSConfigRadioButtons() {
        Division division = new Division();
        division.setCssClass("labelvaluediv");
        Span span = new Span();
        division.add(span);
        span.setCssClass("upsradiospan");
        RadioButton radioButton = new RadioButton("groupcfgradio");
        span.add(radioButton);
        radioButton.setId("singleupsradio");
        radioButton.setValue("single");
        radioButton.setCheck(true);
        Label label = new Label(this.theSingleUPSRadioLabelText);
        span.add(label);
        label.setFor("singleupsradio");
        Span span2 = new Span();
        division.add(span2);
        span2.setCssClass("upsradiospan");
        radioButton = new RadioButton("groupcfgradio");
        span2.add(radioButton);
        radioButton.setId("upsgroupradio");
        radioButton.setValue("group");
        label = new Label(this.theUPSGroupRadioLabelText);
        span2.add(label);
        label.setFor("upsgroupradio");
        return division;
    }

    @Override
    protected void setupLanguage(Locale locale) {
        super.setupLanguage(locale);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theProtocolLabelText = Utils.getResourceString(resourceBundleWrapper, kProtocolLabel);
        this.theProtocolTooltipText = Utils.getResourceString(resourceBundleWrapper, kProtocolTooltip);
        this.thePortLabelText = Utils.getResourceString(resourceBundleWrapper, kPortLabel);
        this.theInvalidPortText = Utils.getResourceString(resourceBundleWrapper, kInvalidPort);
        this.theRequiredFieldText = Utils.getResourceString(resourceBundleWrapper, kRequiredField);
        this.theOKButtonText = Utils.getResourceString(resourceBundleWrapper, kOKButton);
        this.theCancelButtonText = Utils.getResourceString(resourceBundleWrapper, kCancelButton);
        this.theCloseButtonText = Utils.getResourceString(resourceBundleWrapper, kCloseButton);
        this.theUPSGroupsHeaderText = Utils.getResourceString(resourceBundleWrapper, kUPSGroupsHeader);
        this.theAddGroupButtonText = Utils.getResourceString(resourceBundleWrapper, kAddGroupButton);
        this.theNoUPSGroupConfiguredText = Utils.getResourceString(resourceBundleWrapper, kNoUPSGroupConfigured);
        this.theUPSGroupDialogTitleText = Utils.getResourceString(resourceBundleWrapper, kUPSGroupDialogTitle);
        this.theSingleUPSRadioLabelText = Utils.getResourceString(resourceBundleWrapper, kSingleUPSRadioLabel);
        this.theUPSGroupRadioLabelText = Utils.getResourceString(resourceBundleWrapper, kUPSGroupRadioLabel);
        this.theUPSGroupNameLabelText = Utils.getResourceString(resourceBundleWrapper, kUPSGroupNameLabel);
        this.theUPSGroupNameInUseText = Utils.getResourceString(resourceBundleWrapper, kUPSGroupNameInUse);
        this.theUPSGroupNameUSASCIIText = Utils.getResourceString(resourceBundleWrapper, kUPSGroupNameUSASCII);
        this.theIPDialogTitleText = Utils.getResourceString(resourceBundleWrapper, kIPDialogTitle);
        this.theInvalidIPAddressText = Utils.getResourceString(resourceBundleWrapper, kInvalidIPAddress);
        this.theNoIPConfiguredText = Utils.getResourceString(resourceBundleWrapper, kNoIPConfigured);
        this.theMinIPRequiredText = Utils.getResourceString(resourceBundleWrapper, kMinIPRequired);
        this.theAddIPButtonText = Utils.getResourceString(resourceBundleWrapper, kAddIPButton);
        this.theIPHeaderText = Utils.getResourceString(resourceBundleWrapper, kIPHeader);
        this.theIPLabelText = Utils.getResourceString(resourceBundleWrapper, kIPLabel);
        this.theIPInUseText = Utils.getResourceString(resourceBundleWrapper, kIPInUse);
        this.theGroupDeleteTitleText = Utils.getResourceString(resourceBundleWrapper, kGroupDeleteTitle);
        this.theGroupDeleteText = Utils.getResourceString(resourceBundleWrapper, kGroupDelete);
        this.theYesButtonText = Utils.getResourceString(resourceBundleWrapper, kYesButton);
        this.theNoButtonText = Utils.getResourceString(resourceBundleWrapper, kNoButton);
    }
}

