/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.pages;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.servlets.IndividualVMSettings;
import com.apcc.m11.components.webserver.util.VMSettingsHTMLHelper;
import com.apcc.pcns.ServiceManager;

public class VMSettingsPage
extends CfgWizardPage {
    private VMSettings settings = new VMSettings();
    private VMSettingsHTMLHelper helper = null;
    private boolean isHyperV = false;
    private boolean isNutanixAHV = false;
    private boolean isManagedHost = false;
    private boolean isESXi = false;
    private boolean isAdvanced = false;
    private boolean isInit;

    public VMSettingsPage(boolean bl, ServiceManager serviceManager) {
        super(serviceManager);
        this.isInit = bl;
    }

    @Override
    protected String getI11nPrefix() {
        if (this.services.getVirtualConfigurationManager().isHyperV() && this.services.getVirtualConfigurationManager().isManagedHost()) {
            return "CfgWizard.SCVMMSettingsPage";
        }
        return "CfgWizard.VMSettingsPage";
    }

    @Override
    protected String getPageName() {
        return "VMSettingsPage";
    }

    @Override
    protected Integer getHelpId() {
        Integer n = ApcHelp.VIRTUALIZATION_SETTINGS;
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            if (this.services.getVirtualConfigurationManager().isManagedHost()) {
                n = ApcHelp.SCVMM_CONFIGURATION_SCVMM_VIRTUALIZATION_SETTINGS;
            }
            n = ApcHelp.HYPER_V_VIRTUALIZATION_SETTINGS;
        }
        if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            n = ApcHelp.NUTANIX_VIRTUALIZATION_SETTINGS;
        }
        return n;
    }

    @Override
    protected void setupForm(Container container, PageContext pageContext) {
        pageContext.getSession().removeAttribute("fixPage");
        this.isHyperV = this.services.getVirtualConfigurationManager().isHyperV();
        this.isNutanixAHV = this.services.getVirtualConfigurationManager().isNutanixAHV();
        this.isManagedHost = this.services.getVirtualConfigurationManager().isManagedHost();
        this.isESXi = this.services.getVirtualConfigurationManager().isESXi();
        this.isAdvanced = this.services.getAdvancedSetupHelper().isAdvancedShutdownMode();
        boolean bl = this.isHyperV && !this.isManagedHost || !this.isHyperV && this.isManagedHost && !this.isAdvanced;
        this.thePage.addStyleSheet("styles/form.css");
        if (bl) {
            this.thePage.addStyleSheet("jstree/themes/default/style.min.css");
            this.thePage.addStyleSheet("styles/hostmap.css");
        }
        this.thePage.addStyleSheet("styles/vmsettings.css");
        if (bl) {
            this.thePage.addScript("jstree/jstree.min.js");
        }
        this.thePage.addScript("scripts/jquery.validate.min.js");
        this.thePage.addScript("scripts/vmsettings.js");
        if (bl) {
            this.thePage.addScript("scripts/customtargethost.js");
        }
        this.initFormData(pageContext);
        pageContext.getSession().setAttribute("vm_settings", (Object)this.settings);
        if (this.isHyperV) {
            this.helper.createVMSettingsWaitHTML(container, this.settings, true, false, this.isManagedHost);
            this.nextBtn.setDisable(true);
            this.prevBtn.setDisable(true);
        } else {
            this.helper.createVMSettingsHTML(container, this.settings, true, this.isInit, false, false, pageContext.getLocale(), IndividualVMSettings.getSetupId(pageContext));
        }
        this.cancelBtn.setDisable(true);
        this.thePage.add(this.createWaitDialog());
    }

    private void initFormData(PageContext pageContext) {
        this.helper = new VMSettingsHTMLHelper(pageContext.getLocale(), this.services);
        Object object = pageContext.getSession().getAttribute("VMSettings");
        if (object == null || !(object instanceof VMSettings)) {
            if (this.isManagedHost || this.isNutanixAHV) {
                this.settings = this.services.getWebServerUtils().readVMSettingsFromConfigAndCluster();
            } else if (this.isHyperV) {
                this.settings = this.services.getWebServerUtils().readHypervVMSettingsFromConfig();
            }
        } else {
            this.settings = (VMSettings)object;
        }
        if (this.isESXi) {
            this.settings.setPcnsOnVSAN(this.services.getVsanUtils().isPCNSInstalledOnVsanHost());
        }
    }
}

