/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.HostNMCMappingPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.TargetHostSelectionPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.pcns.ServiceManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class HostMapping
extends CfgWizardStateAPC {
    private static final long serialVersionUID = 7523321018405867520L;
    public static final String URL = "/HostMapping";

    public HostMapping() {
        this.id = URL;
    }

    @Override
    public void setSessionValuesForPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        httpSession.setAttribute("nutanix_details", null);
        httpSession.setAttribute("simplivity_details", null);
        httpSession.setAttribute("hyperflex_details", null);
        if (serviceManager.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            httpSession.setAttribute("HostNMCMappingPage", (Object)true);
        } else {
            httpSession.setAttribute("TargetHostSelectionPage", (Object)true);
        }
    }

    @Override
    public CfgWizardPage doLoadPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        CfgWizardPage cfgWizardPage = null;
        cfgWizardPage = serviceManager.getAdvancedSetupHelper().isAdvancedShutdownMode() ? new HostNMCMappingPage(serviceManager) : new TargetHostSelectionPage(serviceManager);
        cfgWizardPage.setAction(null);
        return cfgWizardPage;
    }

    @Override
    public String doGetNextPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        VMWareDetails vMWareDetails = (VMWareDetails)httpSession.getAttribute("vmware_details");
        if (httpSession.getAttribute("undo") != null) {
            httpSession.removeAttribute("undo");
            return URL;
        }
        if (vMWareDetails == null || StringUtils.isBlank((CharSequence)vMWareDetails.getServerIp())) {
            return "SwitchOutletGroup";
        }
        return "HostCertificateManagement";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        if (hTTPServletParameterMap.getString("reset") != null) {
            httpSession.setAttribute("undo", (Object)"reset");
        } else {
            this.storeMappings(httpSession, hTTPServletParameterMap, serviceManager);
        }
    }

    @Override
    public String doGetBackPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        return "/UPSLayout";
    }

    private void storeMappings(HttpSession httpSession, HTTPServletParameterMap hTTPServletParameterMap, ServiceManager serviceManager) {
        if (serviceManager.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            LinkedHashMap<String, MappedHost> linkedHashMap = serviceManager.getWebServerUtils().readMappedHostsFromRequest(hTTPServletParameterMap);
            httpSession.setAttribute("HostNMCMappingPage", (Object)false);
            if (serviceManager.getVirtualConfigurationManager().isESXi()) {
                linkedHashMap = serviceManager.getVsanUtils().checkVsanConfigurationOfMappedHosts(linkedHashMap);
            }
            httpSession.setAttribute("mappedHosts", linkedHashMap);
            serviceManager.getAdvancedSetupHelper().saveMappedHostsToConfig(linkedHashMap);
            if (serviceManager.getVirtualConfigurationManager().isHyperflex()) {
                serviceManager.getHyperflexUtils().saveCvmDetailsToConfig(linkedHashMap);
            }
        } else {
            List<String> list = serviceManager.getWebServerUtils().readTargetHostSelectionFromRequest(hTTPServletParameterMap);
            httpSession.setAttribute("TargetHostSelectionPage", (Object)false);
            if (serviceManager.getVirtualConfigurationManager().isESXi()) {
                list = serviceManager.getVsanUtils().checkVsanConfigurationOfTargetHosts(list);
            }
            httpSession.setAttribute("targetHosts", list);
            serviceManager.getWebServerUtils().saveTargetHostSelectionToConfig(list);
            if (serviceManager.getVirtualConfigurationManager().isHyperflex()) {
                serviceManager.getHyperflexUtils().saveCvmDetailsToConfig(list);
            }
        }
        this.setVMSettingsDefaultValues(httpSession, serviceManager);
    }

    private void setVMSettingsDefaultValues(HttpSession httpSession, ServiceManager serviceManager) {
        if (serviceManager.getVirtualConfigurationManager().isManagedHost()) {
            Object object = httpSession.getAttribute("VMSettings");
            if (!(object instanceof VMSettings)) {
                return;
            }
            VMSettings vMSettings = (VMSettings)object;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (serviceManager.getHostSystemUtils().isVCenterManagedAdvancedMode()) {
                if (httpSession.getAttribute("mappedHosts") != null) {
                    Map map = (Map)httpSession.getAttribute("mappedHosts");
                    bl = serviceManager.getHostSystemUtils().isAnyHostPartOfCluster(map.keySet());
                    bl2 = serviceManager.getHostSystemUtils().isAnyVAppDetectedInCluster(map.keySet());
                    bl3 = serviceManager.getVsanUtils().isAnyMappedHostPartOfVsanCluster(map);
                }
            } else if (serviceManager.getVirtualConfigurationManager().isManagedESXi() && httpSession.getAttribute("targetHosts") != null) {
                List list = (List)httpSession.getAttribute("targetHosts");
                bl = serviceManager.getHostSystemUtils().isAnyHostPartOfCluster(list);
                bl2 = serviceManager.getHostSystemUtils().isAnyVAppDetectedInCluster(list);
                bl3 = serviceManager.getVsanUtils().isAnyTargetHostPartOfVsanCluster(list);
            }
            this.clusterHACSorting(vMSettings, bl, bl2);
            this.clusterVirtualizationSorting(serviceManager, vMSettings, bl3);
        }
    }

    private void clusterHACSorting(VMSettings vMSettings, boolean bl, boolean bl2) {
        if (bl) {
            vMSettings.setGuestVMVAppShutdownEnabled(true);
            if (bl2) {
                vMSettings.setForcevAppShutdownEnabled(true);
            }
        }
    }

    private void clusterVirtualizationSorting(ServiceManager serviceManager, VMSettings vMSettings, boolean bl) {
        if (serviceManager.getVirtualConfigurationManager().isHCISystem() || bl || serviceManager.getVirtualConfigurationManager().isSimplivity()) {
            boolean bl2 = serviceManager.getConfigurationManager().getBoolean("HostConfigSettings", "delay_maintenance_mode", true);
            int n = serviceManager.getConfigurationManager().getInt("HostConfigSettings", "delay_maintenance_mode_timeout", 240);
            boolean bl3 = serviceManager.getVirtualConfigurationManager().isConfigWizardComplete();
            if (!bl3) {
                vMSettings.setHostMaintenanceModeDelayed(true);
            } else {
                vMSettings.setHostMaintenanceModeDelayed(bl2);
            }
            vMSettings.setHostMaintenanceModeTimeout(n);
        }
    }
}

