/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.SimplivityConnectionPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.simplivity.SimplivityDetails;
import java.util.List;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpliVityConnection
extends CfgWizardStateAPC {
    private static final long serialVersionUID = 2690334717416233528L;
    private static final Logger logger = LogManager.getLogger(SimpliVityConnection.class);
    public static final String URL = "/SimpliVityConnection";

    public SimpliVityConnection() {
        this.id = URL;
    }

    @Override
    public void setSessionValuesForPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        List<SimplivityDetails> list = (List<SimplivityDetails>)httpSession.getAttribute("simplivity_details");
        if (list == null && (list = serviceManager.getSimplivityUtils().loadSimplivityDetails()).isEmpty()) {
            list.add(new SimplivityDetails());
        }
        httpSession.setAttribute("simplivity_details", list);
    }

    @Override
    public CfgWizardPage doLoadPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        SimplivityConnectionPage simplivityConnectionPage = new SimplivityConnectionPage(serviceManager);
        simplivityConnectionPage.setAction(null);
        return simplivityConnectionPage;
    }

    @Override
    public String doGetNextPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        return "SwitchOutletGroup";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        logger.debug("storeSimplivityClusterDetails() - start");
        List<SimplivityDetails> list = serviceManager.getSimplivityUtils().parseSimplivityDetails(hTTPServletParameterMap);
        if (!list.isEmpty() && StringUtils.isNotBlank((CharSequence)list.get(0).getHost())) {
            serviceManager.getSimplivityUtils().saveSimplivityDetails(list);
        }
        httpSession.setAttribute("simplivity_details", list);
    }
}

