/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.P09SOutletGroupSelectPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.pcns.ServiceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwitchOutletGroup
extends CfgWizardStateAPC {
    private static final long serialVersionUID = -7454084924518171522L;
    private static final Logger logger = LogManager.getLogger(SwitchOutletGroup.class);
    public static final String URL = "/SOG";

    public SwitchOutletGroup() {
        this.id = URL;
    }

    @Override
    public CfgWizardPage doLoadPage(ServiceManager serviceManager) {
        P09SOutletGroupSelectPage p09SOutletGroupSelectPage = new P09SOutletGroupSelectPage(serviceManager);
        p09SOutletGroupSelectPage.setAction(null);
        return p09SOutletGroupSelectPage;
    }

    @Override
    public String doGetNextPage(HttpSession httpSession, ServiceManager serviceManager) {
        if (this.hasSOG(httpSession)) {
            return "/OutletSet";
        }
        return "/VMSettingsSelection";
    }

    @Override
    public String doGetBackPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        return "/UPSLayout";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        List<OutletGroup> list = new ArrayList<OutletGroup>();
        for (Map.Entry entry : hTTPServletParameterMap.entrySet()) {
            String string = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            list = this.handleEntryData(string, stringArray[0], list);
        }
        if (!list.isEmpty()) {
            httpSession.setAttribute("mappedOutletGroups", list);
        }
    }

    protected List<OutletGroup> handleEntryData(String string, String string2, List<OutletGroup> list) {
        if (string != null && string.startsWith("UpsEntryOGs_combo_")) {
            String string3 = string.substring("UpsEntryOGs_combo_".length());
            String string4 = string2;
            OutletGroup outletGroup = null;
            try {
                outletGroup = this.defineOutletGroup(string4, string3);
                list.add(outletGroup);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)numberFormatException);
            }
            if (string2.length() > 1) {
                logger.error("Only one outlet group per IP is allowed");
            }
        }
        return list;
    }

    protected OutletGroup defineOutletGroup(String string, String string2) {
        return new OutletGroup(Integer.valueOf(string), null, null, string2, false);
    }

    private boolean hasSOG(HttpSession httpSession) {
        Object object = httpSession.getAttribute("hasSOG");
        return object instanceof String && ((String)object).equals("true");
    }
}

