/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.Setting;
import com.apcc.m11.components.webserver.cfgwizard.pages.UPSGroupsPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.util.CfgWizardHelper;
import com.apcc.pcns.ServiceManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpsGroups
extends CfgWizardStateAPC {
    private static final Logger logger = LogManager.getLogger(UpsGroups.class);
    private static final long serialVersionUID = 596876875113995961L;
    public static final String URL = "/UpsGroups";

    public UpsGroups() {
        this.id = URL;
    }

    @Override
    public CfgWizardPage doLoadPage(ServiceManager serviceManager) {
        UPSGroupsPage uPSGroupsPage = new UPSGroupsPage(serviceManager);
        uPSGroupsPage.setAction(null);
        return uPSGroupsPage;
    }

    @Override
    public String doGetNextPage(HttpSession httpSession, ServiceManager serviceManager) {
        return "/UpsConfigConfirmation";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap) {
        String string;
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("params is marked non-null but is null");
        }
        String string2 = hTTPServletParameterMap.getString(Setting.Protocol.toString());
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            httpSession.setAttribute(Setting.Protocol.toString(), (Object)string2);
        }
        if (StringUtils.isNotBlank((CharSequence)(string = hTTPServletParameterMap.getString(Setting.Port.toString())))) {
            httpSession.setAttribute(Setting.Port.toString(), (Object)string);
        }
        this.updateUpsIp(httpSession, hTTPServletParameterMap);
        this.updateUpsGroups(httpSession, hTTPServletParameterMap);
    }

    private boolean isIpV6(HttpSession httpSession) {
        return StringUtils.equalsIgnoreCase((CharSequence)Integer.toString(2), (CharSequence)CfgWizardHelper.getNetworkConfiguration(httpSession));
    }

    private List<String> getFormattedIpAddresses(HttpSession httpSession, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.isIpV6(httpSession);
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray2[i];
            if (bl) {
                try {
                    string2 = InetAddress.getByName(string).getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    logger.error((Object)unknownHostException);
                }
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void updateUpsIp(HttpSession httpSession, HTTPServletParameterMap hTTPServletParameterMap) {
        String string = hTTPServletParameterMap.getString("upsip");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String[] stringArray = StringUtils.split((String)string, (String)"|");
            List<String> list = this.getFormattedIpAddresses(httpSession, stringArray);
            httpSession.setAttribute("ipAddresses", (Object)ArrayUtils.toStringArray((Object[])list.toArray()));
        }
    }

    private void updateUpsGroups(HttpSession httpSession, HTTPServletParameterMap hTTPServletParameterMap) {
        String[] stringArray = (String[])hTTPServletParameterMap.get("upsgroup");
        if (stringArray != null) {
            List list = (List)httpSession.getAttribute("advSettings");
            ArrayList<UPSSetup> arrayList = new ArrayList<UPSSetup>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            boolean bl = this.isIpV6(httpSession);
            for (String string : stringArray) {
                if (StringUtils.isEmpty((CharSequence)string)) continue;
                Object[] objectArray = StringUtils.split((String)string, (String)"|");
                Object object = null;
                if (ArrayUtils.isNotEmpty((Object[])objectArray)) {
                    object = objectArray[0];
                }
                UPSSetup uPSSetup = null;
                uPSSetup = this.initUPSSetup(list, uPSSetup, (String)object);
                int n = 0;
                arrayList.add(uPSSetup);
                this.storeIpAddressToUPSSetup((String[])objectArray, n, bl, uPSSetup, arrayList2);
                if (uPSSetup.getUpsRequiredForLoad() <= arrayList2.size()) continue;
                uPSSetup.setUpsRequiredForLoad(arrayList2.size());
            }
            httpSession.setAttribute("advSettings", arrayList);
            httpSession.setAttribute("ipAddresses", (Object)ArrayUtils.toStringArray((Object[])arrayList2.toArray()));
        }
    }

    private UPSSetup initUPSSetup(List<UPSSetup> list, UPSSetup uPSSetup, String string) {
        if (list != null) {
            for (UPSSetup uPSSetup2 : list) {
                if (!uPSSetup2.getName().equals(string)) continue;
                uPSSetup = uPSSetup2;
                uPSSetup.getNMCList().clear();
            }
        }
        if (uPSSetup == null) {
            uPSSetup = new UPSSetup();
        }
        return uPSSetup;
    }

    private void storeIpAddressToUPSSetup(String[] stringArray, int n, boolean bl, UPSSetup uPSSetup, List<String> list) {
        for (String string : stringArray) {
            if (n > 0) {
                String string2 = string;
                if (bl) {
                    try {
                        string2 = InetAddress.getByName(string).getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        logger.error((Object)unknownHostException);
                    }
                }
                uPSSetup.addNMC(string2);
                list.add(string2);
            } else {
                uPSSetup.setName(string);
            }
            ++n;
        }
    }
}

