/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.VMSettingsPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.vmware.vim25.mo.ServiceInstance;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.commons.beanutils.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMSettingsSelection
extends CfgWizardStateAPC {
    private static final long serialVersionUID = -4859619492827483362L;
    public static final String URL = "/VMSettingsSelection";
    private static final Logger logger = LogManager.getLogger(VMSettingsSelection.class);

    public VMSettingsSelection() {
        this.id = URL;
    }

    @Override
    public CfgWizardPage doLoadPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        boolean bl = serviceManager.getVirtualConfigurationManager().isConfigWizardComplete();
        VMSettingsPage vMSettingsPage = new VMSettingsPage(bl, serviceManager);
        vMSettingsPage.setAction(null);
        return vMSettingsPage;
    }

    @Override
    public String doGetNextPage(HttpSession httpSession, ServiceManager serviceManager) {
        return "/VMSettingsConfirm";
    }

    @Override
    public String doGetBackPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        return "/UPSLayout";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap, @NonNull ServiceManager serviceManager) {
        VMSettings vMSettings;
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        if (hTTPServletParameterMap.getString("vmsettingsHiddenInput") != null && (vMSettings = this.getVMSettings(hTTPServletParameterMap, serviceManager)) != null) {
            vMSettings.setApplySettingsToAllGroups(true);
            String string = "";
            boolean bl = false;
            try {
                string = this.getCurrentPluginValue(serviceManager);
                bl = this.getIsPluginEnabled(serviceManager);
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            serviceManager.getWebServerUtils().saveVMSettingsToConfig(vMSettings, serviceManager.getAdvancedSetupHelper().isAdvancedShutdownMode());
            httpSession.setAttribute("VMSettings", (Object)vMSettings);
        }
    }

    protected VMSettings getVMSettings(HTTPServletParameterMap hTTPServletParameterMap, ServiceManager serviceManager) {
        return serviceManager.getWebServerUtils().readVMSettingsFromRequest(hTTPServletParameterMap);
    }

    protected String getCurrentPluginValue(ServiceManager serviceManager) {
        if (serviceManager.getConfigurationManager().containsKey("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE)) {
            return serviceManager.getConfigurationManager().getString("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE);
        }
        return "";
    }

    protected boolean getIsPluginEnabled(ServiceManager serviceManager) {
        if (serviceManager.getConfigurationManager().containsKey("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN)) {
            return serviceManager.getConfigurationManager().getBoolean("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN);
        }
        return false;
    }

    protected VMWareDetails getVMWareDetails(HttpSession httpSession) {
        VMWareDetails vMWareDetails = (VMWareDetails)httpSession.getAttribute("vmware_details");
        if (vMWareDetails == null) {
            vMWareDetails = new VMWareDetails();
        }
        return vMWareDetails;
    }

    protected ServiceInstance getServiceInstance(VMWareDetails vMWareDetails, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        ServiceInstance serviceInstance = this.getVCenterConnection(serviceManager);
        if (serviceInstance == null) {
            try {
                serviceInstance = this.getVCenterConnection(vMWareDetails, serviceManager);
            }
            catch (MalformedURLException | RemoteException iOException) {
                logger.debug("Failed to get VCenter server instance, error {}", (Object)iOException.getMessage());
            }
        }
        return serviceInstance;
    }

    protected ServiceInstance getVCenterConnection(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        VMWareConnection vMWareConnection = serviceManager.getVmWareConnection();
        return vMWareConnection.getVCenterConnection();
    }

    protected ServiceInstance getVCenterConnection(VMWareDetails vMWareDetails, @NonNull ServiceManager serviceManager) throws RemoteException, MalformedURLException {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        VMWareConnection vMWareConnection = serviceManager.getVmWareConnection();
        return vMWareConnection.getVCenterConnection(vMWareDetails, false);
    }
}

