/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.NutanixConnectionPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixDetails;
import com.apcc.pcns.ServiceManager;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualisationNutanixCluster
extends CfgWizardStateAPC {
    private static final long serialVersionUID = -3918022041748914950L;
    private static final Logger logger = LogManager.getLogger(VirtualisationNutanixCluster.class);
    public static final String URL = "/NutanixCluster";

    public VirtualisationNutanixCluster() {
        this.id = URL;
    }

    @Override
    public void setSessionValuesForPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        NutanixDetails nutanixDetails = (NutanixDetails)httpSession.getAttribute("nutanix_details");
        if (nutanixDetails == null) {
            nutanixDetails = serviceManager.getNutanixUtils().loadNutanixDetails();
            httpSession.setAttribute("nutanix_details", (Object)nutanixDetails);
        }
    }

    @Override
    public CfgWizardPage doLoadPage(ServiceManager serviceManager) {
        NutanixConnectionPage nutanixConnectionPage = new NutanixConnectionPage(serviceManager);
        nutanixConnectionPage.setAction(null);
        return nutanixConnectionPage;
    }

    @Override
    public String doGetNextPage(HttpSession httpSession, ServiceManager serviceManager) {
        return "/UPSLayout";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        logger.debug("doUpdateSession() - start");
        String string = hTTPServletParameterMap.getString("nutanix_cluster_ip");
        String string2 = hTTPServletParameterMap.getString("nutanix_cluster_password");
        String string3 = hTTPServletParameterMap.getString("nutanix_host_password");
        if (StringUtils.isBlank((CharSequence)string3)) {
            string3 = string2;
        }
        String string4 = hTTPServletParameterMap.getString("nutanix_ssh_key_path");
        String string5 = hTTPServletParameterMap.getString("nutanix_ssh_key_passphrase");
        NutanixDetails nutanixDetails = new NutanixDetails(string, string2, string3, string4, string5);
        httpSession.setAttribute("nutanix_details", (Object)nutanixDetails);
    }
}

