/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.VCenterServerDetailsPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.userinterface.HyperconvergedSupport;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualisationVCenter
extends CfgWizardStateAPC {
    private static final long serialVersionUID = -3918022041748914950L;
    private static final Logger logger = LogManager.getLogger(VirtualisationVCenter.class);
    public static final String URL = "/VCenter";

    public VirtualisationVCenter() {
        this.id = URL;
    }

    @Override
    public CfgWizardPage doLoadPage(ServiceManager serviceManager) {
        VCenterServerDetailsPage vCenterServerDetailsPage = new VCenterServerDetailsPage(serviceManager);
        vCenterServerDetailsPage.setAction(null);
        return vCenterServerDetailsPage;
    }

    @Override
    public String doGetNextPage(HttpSession httpSession, ServiceManager serviceManager) {
        HyperconvergedSupport hyperconvergedSupport = serviceManager.getVirtualConfigurationManager().getHyperconvergedSupportValueFromSession(httpSession);
        if (hyperconvergedSupport == HyperconvergedSupport.NUTANIX) {
            return "/NutanixCluster";
        }
        return "/UPSLayout";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        logger.debug("doUpdateSession() - start");
        if (hTTPServletParameterMap.containsKey("vcenter_server_protocol") && hTTPServletParameterMap.containsKey("vcenter_server_port") && hTTPServletParameterMap.containsKey("vcenter_server_ip") && hTTPServletParameterMap.containsKey("vcenter_server_username") && hTTPServletParameterMap.containsKey("vcenter_server_password")) {
            Object object;
            Object object2;
            String string = hTTPServletParameterMap.getString("vcenter_server_protocol");
            String string2 = hTTPServletParameterMap.getString("vcenter_server_port");
            String string3 = hTTPServletParameterMap.getString("vcenter_server_ip");
            String string4 = hTTPServletParameterMap.getString("vcenter_server_username");
            String string5 = hTTPServletParameterMap.getString("vcenter_server_password");
            boolean bl = false;
            if (hTTPServletParameterMap.containsKey("vcenter_installed_on_vm")) {
                object2 = hTTPServletParameterMap.getString("vcenter_installed_on_vm");
                bl = "on".equalsIgnoreCase((String)object2) ? Boolean.TRUE : Boolean.FALSE;
            }
            object2 = HyperconvergedSupport.NONE;
            if (hTTPServletParameterMap.containsKey("hyperconverged_support")) {
                object = hTTPServletParameterMap.getString("hyperconverged_support");
                object2 = HyperconvergedSupport.fromINISetting((String)object);
                logger.debug("doUpdateSession() - Hyperconverged choice: {}", object);
            }
            object = new VMWareDetails(string, string2, string3, string4, string5, false);
            ((VMWareDetails)object).setVCenterInstalledOnaVM(bl);
            ((VMWareDetails)object).setHyperconvergedSupport((HyperconvergedSupport)((Object)object2));
            httpSession.setAttribute("vmware_details", object);
            httpSession.setAttribute("vcenter_server_details", object);
        }
    }
}

