/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.states;

import com.apcc.m11.components.webserver.cfgwizard.CfgWizardPage;
import com.apcc.m11.components.webserver.cfgwizard.pages.VxRailConnectionPage;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.userinterface.HyperconvergedSupport;
import com.apcc.pcns.vxrail.VxRailDetails;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VxRailConnection
extends CfgWizardStateAPC {
    private static final Logger logger = LogManager.getLogger(VxRailConnection.class);
    private static final long serialVersionUID = 1L;
    public static final String URL = "/VxRailConnection";

    public VxRailConnection() {
        this.id = URL;
    }

    @Override
    public void setSessionValuesForPage(@NonNull HttpSession httpSession, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        if (!(httpSession.getAttribute("vxrail_details") instanceof VxRailDetails)) {
            httpSession.setAttribute("vxrail_details", (Object)serviceManager.getVxRailUtils().loadVxRailDetails());
        }
        HyperconvergedSupport hyperconvergedSupport = serviceManager.getVirtualConfigurationManager().getHyperconvergedSupportValueFromSession(httpSession);
        serviceManager.getVirtualConfigurationManager().setHyperconvergedSupport(hyperconvergedSupport);
    }

    @Override
    public CfgWizardPage doLoadPage(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        VxRailConnectionPage vxRailConnectionPage = new VxRailConnectionPage(serviceManager);
        vxRailConnectionPage.setAction(null);
        return vxRailConnectionPage;
    }

    @Override
    public String doGetNextPage(HttpSession httpSession, ServiceManager serviceManager) {
        return "SwitchOutletGroup";
    }

    @Override
    public void doUpdateSession(@NonNull HttpSession httpSession, @NonNull HTTPServletParameterMap hTTPServletParameterMap, @NonNull ServiceManager serviceManager) {
        if (httpSession == null) {
            throw new IllegalArgumentException("session is marked non-null but is null");
        }
        if (hTTPServletParameterMap == null) {
            throw new IllegalArgumentException("parameterMap is marked non-null but is null");
        }
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        logger.debug("doUpdateSession() - start");
        VxRailDetails vxRailDetails = (VxRailDetails)httpSession.getAttribute("vxrail_details");
        if (vxRailDetails == null) {
            vxRailDetails = serviceManager.getVxRailUtils().loadVxRailDetails();
        }
        String string = StringUtils.trim((String)hTTPServletParameterMap.getString("vxrail_cluster_ip"));
        vxRailDetails.setVxRailManagerIp(string);
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            serviceManager.getVxRailUtils().saveVxRailDetails(vxRailDetails);
        }
        httpSession.setAttribute("vxrail_details", (Object)vxRailDetails);
    }
}

