/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.cfgwizard.tasks;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.cfgwizard.SessionManager;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DisplayOutletsRunnable
implements Runnable {
    private static final Logger logger = LogManager.getLogger(DisplayOutletsRunnable.class);
    private PageContext context;
    private ServiceManager services;

    public DisplayOutletsRunnable(PageContext pageContext, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.context = pageContext;
        this.services = serviceManager;
    }

    @Override
    public void run() {
        Vector<InetAddress> vector;
        ArrayList<OutletGroup> arrayList = new ArrayList<OutletGroup>();
        Object object = this.context.get(TCPIPCommunication.IpAddress.getObjectId());
        if (object != null) {
            vector = null;
            if (object instanceof Vector) {
                vector = (Vector)object;
            } else {
                vector = new Vector<InetAddress>();
                if (object instanceof InetAddress) {
                    vector.add((InetAddress)object);
                }
            }
            for (InetAddress serializable : vector) {
                OutletGroup outletGroup = new OutletGroup(null, null, null, serializable.getHostAddress(), false);
                arrayList.add(outletGroup);
            }
            for (OutletGroup outletGroup : arrayList) {
                this.context.set(TCPIPCommunication.OutletGroup.getObjectId(), outletGroup);
            }
        }
        vector = new SessionManager(this.services);
        ((SessionManager)((Object)vector)).applySettings(this.context);
        ((SessionManager)((Object)vector)).applyGlobalVMSettings(this.context);
        this.services.getAdvancedSetupHelper().initializeSingleUPSSetupSetting(this.context);
        this.context.getSession().setAttribute("applySettingsDone", (Object)Boolean.TRUE);
    }
}

