/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.filters;

import com.apcc.m11.components.webserver.WebServerSettings;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccessControlAllowOriginFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(AccessControlAllowOriginFilter.class);
    private WebServerSettings theWebServerSettings;
    private ServiceManager services;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, @NonNull FilterChain filterChain) throws IOException, ServletException, IllegalArgumentException {
        if (filterChain == null) {
            throw new IllegalArgumentException("chain is marked non-null but is null");
        }
        logger.debug("doFilter() - start");
        if (servletResponse instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            try {
                this.services = ServiceManager.getInstance();
                this.theWebServerSettings = new WebServerSettings(this.services);
                String string = this.theWebServerSettings.getHTTPSServerAddress().replaceAll(",", "");
                httpServletResponse.addHeader("Access-Control-Allow-Origin", string);
                filterChain.doFilter(servletRequest, servletResponse);
            }
            catch (Exception exception) {
                logger.debug("doFilter() - failed: {}", (Throwable)exception);
            }
        }
        logger.debug("doFilter() - end");
    }

    public void destroy() {
    }
}

