/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.filters;

import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Response;

public class HeaderFilter
implements Filter {
    private static final Logger logger = LogManager.getLogger(HeaderFilter.class);
    private ServiceManager services;
    private String loopback;
    private String hostNameCanonical;
    private String hostName;
    private Set<String> localIPs;

    public HeaderFilter(ServiceManager serviceManager) {
        this.services = serviceManager;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.hostName = inetAddress.getHostName();
            this.hostNameCanonical = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error("Unable to resolve PCNS Host Name. Will rely on IP address instead", (Throwable)unknownHostException);
        }
        this.loopback = InetAddress.getLoopbackAddress().getCanonicalHostName();
        this.localIPs = this.getLocalIPAddresses();
        logger.info("Setting names: {},{},{},{}", (Object)this.hostName, (Object)this.hostNameCanonical, (Object)this.loopback, this.localIPs);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        logger.debug("doFilter() - start");
        if (servletResponse instanceof Response) {
            Response response = (Response)servletResponse;
            HttpURI httpURI = response.getRequest().getHttpURI();
            logger.debug("doFilter() - checking the request URI to  {}", (Object)httpURI);
            if (!this.isValid(httpURI.getHost())) {
                String string = this.hostNameCanonical.toLowerCase();
                if (StringUtils.isBlank((CharSequence)string)) {
                    string = this.services.getConfigurationManager().getString("Networking", "localHostAddress");
                }
                String string2 = this.services.getConfigurationManager().getString("Networking", "httpsPort");
                HttpURI.Immutable immutable = HttpURI.from((String)("https://" + string + ":" + string2));
                logger.error("doFilter() - invalid host request {} detected. Setting the request URI to  {}", (Object)httpURI, (Object)immutable);
                response.getRequest().setAttribute("javax.servlet.forward.request_uri", (Object)immutable);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
        logger.debug("doFilter() - end");
    }

    private boolean isValid(String string) {
        boolean bl = false;
        String string2 = this.services.getConfigurationManager().getString("Networking", "localHostAddress");
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)string, (CharSequence[])new CharSequence[]{"localhost", this.hostNameCanonical, this.hostName, string2, this.loopback})) {
            logger.debug("isValid() - Found hostname");
            bl = true;
        }
        if (this.localIPs.contains(string)) {
            logger.debug("isValid() - Found host IP");
            bl = true;
        }
        return bl;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private Set<String> getLocalIPAddresses() {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    logger.debug("Adding " + inetAddress.getHostAddress() + " to ip set.");
                    hashSet.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            logger.error((Object)socketException);
        }
        logger.debug("getLocalIPAddresses() - returns {}", hashSet);
        return hashSet;
    }
}

